/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter.custom;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.vaadin.copilot.javarewriter.ComponentInfo;
import com.vaadin.copilot.javarewriter.FlowComponentQuirks;
import com.vaadin.copilot.javarewriter.InsertionPoint;
import com.vaadin.copilot.javarewriter.JavaComponent;
import com.vaadin.copilot.javarewriter.JavaRewriter;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import com.vaadin.copilot.javarewriter.custom.CustomComponentHandle;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DashboardComponentHandle
extends CustomComponentHandle {
    private static final String DASHBOARD_TAG = "Dashboard";
    private static final String DASHBOARD_SECTION_TAG = "DashboardSection";
    private static final String DASHBOARD_WIDGET_TAG = "DashboardWidget";
    private static final String SECTION_TITLE_PROP_KEY = "sectionTitle";
    private static final String WIDGET_TITLE_PROP_KEY = "widgetTitle";
    private static final String STYLE = "style";

    @Override
    public List<VariableDeclarator> createComponentStatements(JavaRewriter javaRewriter, JavaComponent component, InsertionPoint insertionPoint, JavaComponent parent, String layoutVariableName, ComponentInfo referenceComponent, JavaRewriter.AddTemplateOptions options) {
        String componentClassName = FlowComponentQuirks.getClassForComponent(component);
        ClassOrInterfaceType fullType = StaticJavaParser.parseClassOrInterfaceType((String)componentClassName);
        JavaRewriterUtil.addImport(javaRewriter.getCompilationUnit(), fullType.getNameWithScope());
        String variableName = JavaRewriterUtil.generateVariableName(component, fullType, insertionPoint);
        VariableDeclarator variableDeclarator = new VariableDeclarator((Type)fullType.removeScope(), variableName);
        ObjectCreationExpr creationExpr = new ObjectCreationExpr();
        creationExpr.setType(fullType.removeScope());
        variableDeclarator.setInitializer((Expression)creationExpr);
        VariableDeclarationExpr varDeclaration = new VariableDeclarationExpr(variableDeclarator);
        insertionPoint.add((Statement)new ExpressionStmt((Expression)varDeclaration));
        if (DASHBOARD_SECTION_TAG.equals(component.tag()) && component.props().containsKey(SECTION_TITLE_PROP_KEY)) {
            creationExpr.addArgument((Expression)new StringLiteralExpr((String)component.props().get(SECTION_TITLE_PROP_KEY)));
            component.props().remove(SECTION_TITLE_PROP_KEY);
        }
        if (DASHBOARD_WIDGET_TAG.equals(component.tag()) && component.props().containsKey(WIDGET_TITLE_PROP_KEY)) {
            creationExpr.addArgument((Expression)new StringLiteralExpr((String)component.props().get(WIDGET_TITLE_PROP_KEY)));
            component.props().remove(WIDGET_TITLE_PROP_KEY);
        }
        this.replaceCssVariablesWithMethodCalls(component, insertionPoint, variableDeclarator.getNameAsExpression());
        for (Map.Entry<String, Object> entry : component.props().entrySet()) {
            Map styleProperties;
            String prop = entry.getKey();
            Object value = entry.getValue();
            if (STYLE.equals(prop) && value instanceof Map && (styleProperties = (Map)value).isEmpty()) continue;
            JavaRewriter.SetterAndValue setterAndValue = JavaRewriterUtil.getSetterAndValue(JavaRewriterUtil.getClass(componentClassName), prop, value);
            javaRewriter.insertSetter(insertionPoint, (Expression)new NameExpr(variableName), setterAndValue.setter(), setterAndValue.value(), javaRewriter.getCompilationUnit(), component);
        }
        if (!component.children().isEmpty()) {
            javaRewriter.createComponentStatements(insertionPoint, component, component.children(), variableName, null, options);
        }
        javaRewriter.attachComponent(insertionPoint, component, parent, layoutVariableName, referenceComponent, (Expression)new NameExpr(variableName), variableName);
        return List.of(variableDeclarator);
    }

    private void replaceCssVariablesWithMethodCalls(JavaComponent component, InsertionPoint insertionPoint, NameExpr scope) {
        if (DASHBOARD_TAG.equals(component.tag())) {
            Optional<Map<?, ?>> mapStylePropertiesOptional = this.getMapStyleProperties(component);
            if (mapStylePropertiesOptional.isEmpty()) {
                return;
            }
            Map<?, ?> styleProperties = mapStylePropertiesOptional.get();
            styleProperties.forEach((key, value) -> {
                if (key.equals("--vaadin-dashboard-col-min-width")) {
                    MethodCallExpr expr = new MethodCallExpr("setMinimumColumnWidth", new Expression[]{new StringLiteralExpr(value.toString())});
                    expr.setScope((Expression)scope);
                    insertionPoint.add((Statement)new ExpressionStmt((Expression)expr));
                } else if (key.equals("--vaadin-dashboard-col-max-count")) {
                    MethodCallExpr expr = new MethodCallExpr("setMaximumColumnCount", new Expression[]{new IntegerLiteralExpr(value.toString())});
                    expr.setScope((Expression)scope);
                    insertionPoint.add((Statement)new ExpressionStmt((Expression)expr));
                }
            });
            styleProperties.remove("--vaadin-dashboard-col-min-width");
            styleProperties.remove("--vaadin-dashboard-col-max-count");
            return;
        }
        if (DASHBOARD_WIDGET_TAG.equals(component.tag())) {
            Optional<Map<?, ?>> mapStylePropertiesOptional = this.getMapStyleProperties(component);
            if (mapStylePropertiesOptional.isEmpty()) {
                return;
            }
            Map<?, ?> styleProperties = mapStylePropertiesOptional.get();
            styleProperties.forEach((key, value) -> {
                if (key.equals("--vaadin-dashboard-item-rowspan")) {
                    MethodCallExpr expr = new MethodCallExpr("setRowspan", new Expression[]{new IntegerLiteralExpr(value.toString())});
                    expr.setScope((Expression)scope);
                    insertionPoint.add((Statement)new ExpressionStmt((Expression)expr));
                } else if (key.equals("--vaadin-dashboard-item-colspan")) {
                    MethodCallExpr expr = new MethodCallExpr("setColspan", new Expression[]{new IntegerLiteralExpr(value.toString())});
                    expr.setScope((Expression)scope);
                    insertionPoint.add((Statement)new ExpressionStmt((Expression)expr));
                }
            });
            styleProperties.remove("--vaadin-dashboard-item-rowspan");
            styleProperties.remove("--vaadin-dashboard-item-colspan");
        }
    }

    private Optional<Map<?, ?>> getMapStyleProperties(JavaComponent component) {
        if (!component.props().containsKey(STYLE)) {
            return Optional.empty();
        }
        Object object = component.props().get(STYLE);
        if (object instanceof Map) {
            Map styleProperties = (Map)object;
            return Optional.of(styleProperties);
        }
        return Optional.empty();
    }
}

