/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.startup;

import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TypeScriptBootstrapModifier;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.flow.theme.ThemeDefinition;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class CopilotLoader
implements TypeScriptBootstrapModifier {
    private String themeImportFolder;

    public void modify(List<String> bootstrapTypeScript, Options options, FrontendDependenciesScanner frontendDependenciesScanner) {
        if (options.isProductionMode()) {
            return;
        }
        ThemeDefinition themeDefinition = frontendDependenciesScanner.getThemeDefinition();
        this.themeImportFolder = themeDefinition != null && themeDefinition.getTheme() != null && themeDefinition.getTheme().getName().equals("com.vaadin.flow.theme.material") ? "material" : "lumo";
        String connectClientPath = CopilotLoader.getConnectClientPath(options);
        if (connectClientPath != null) {
            bootstrapTypeScript.addAll(0, List.of(String.format("import client from '%s';\nlet generatedId = 0;\nconst copilotMiddleware: any = async function(\n  context: any,\n  next: any\n) {\n    generatedId++;\n    const requestData = { endpoint: context.endpoint, method: context.method, params: context.params, id: generatedId };\n    (window as any).Vaadin.copilot.eventbus.emit('endpoint-request', requestData);\n\n    const response: Response = await next(context);\n    const text = await response.clone().text();\n    const responseData = { text, id: generatedId} ;\n    (window as any).Vaadin.copilot.eventbus.emit('endpoint-response', responseData);\n\n    return response;\n};\n\nclient.middlewares = [...client.middlewares, copilotMiddleware];\n", connectClientPath)));
        }
        if (options.isReactEnabled() && this.hasNpmModule(options, "react-router-dom")) {
            bootstrapTypeScript.add("import { Outlet } from 'react-router-dom';\n(window as any).Vaadin ??= {};\n(window as any).Vaadin.copilot ??= {};\n(window as any).Vaadin.copilot._ref ??= {};\n(window as any).Vaadin.copilot._ref.Outlet = Outlet;\n");
        }
        ArrayList<String> addAtTopList = new ArrayList<String>();
        addAtTopList.addAll(List.of("import 'Frontend/generated/jar-resources/copilot.js';", "// @ts-ignore\nif (import.meta.hot) {\n  // @ts-ignore\n  import.meta.hot.on('vite:afterUpdate', () => {\n    const eventbus = (window as any).Vaadin.copilot.eventbus;\n    if (eventbus) {\n      eventbus.emit('vite-after-update',{});\n    }\n  });\n}\n"));
        if (!options.isNpmExcludeWebComponents()) {
            addAtTopList.addAll(List.of(this.themedImport("vertical-layout"), this.themedImport("horizontal-layout"), this.themedImport("context-menu"), this.themedImport("checkbox"), this.themedImport("text-field"), this.themedImport("text-area"), this.themedImport("menu-bar"), this.themedImport("grid"), this.themedImport("grid", "vaadin-grid-tree-column.js"), this.themedImport("details"), this.themedImport("select"), this.themedImport("overlay"), this.themedImport("list-box"), this.themedImport("combo-box"), this.themedImport("item"), this.themedImport("dialog"), this.themedImport("multi-select-combo-box"), "import '@vaadin/icons/vaadin-iconset.js';", "import '@vaadin/icon/vaadin-icon.js';"));
        }
        bootstrapTypeScript.addAll(0, addAtTopList);
    }

    private boolean hasNpmModule(Options options, String ... moduleName) {
        Path modulePath = options.getNpmFolder().toPath().resolve(Path.of("node_modules", moduleName));
        return modulePath.toFile().exists();
    }

    private static String getConnectClientPath(Options options) {
        File customConnectClient = new File(options.getFrontendDirectory(), "connect-client.ts");
        File defaultConnectClient = new File(options.getFrontendGeneratedFolder(), "connect-client.default.ts");
        String connectClientPath = null;
        if (customConnectClient.exists()) {
            connectClientPath = "Frontend/connect-client.js";
        } else if (defaultConnectClient.exists()) {
            connectClientPath = "Frontend/generated/connect-client.default.js";
        }
        return connectClientPath;
    }

    private String themedImport(String component) {
        return this.themedImport(component, "vaadin-" + component + ".js");
    }

    private String themedImport(String component, String filename) {
        return "import '@vaadin/{component}/theme/{theme}/{filename}';".replace("{component}", component).replace("{theme}", this.themeImportFolder).replace("{filename}", filename);
    }
}

