package com.vaadin.copilot;

import java.io.File;

import org.apache.commons.io.FilenameUtils;

public class KotlinUtil {
    private KotlinUtil() {
    }

    /**
     * Checks file extension is kotlin extensions .e.g kt, kts and throws
     * {@link KotlinNotSupportedException} when file has one of the extensions
     *
     * @param file
     *            File to check
     */
    public static void throwIfKotlin(File file) {
        if (file == null) {
            return;
        }
        if (FilenameUtils.isExtension(file.getName(), "kt", "kts")) {
            throw new KotlinNotSupportedException();
        }
    }

}
