package com.vaadin.copilot;

/**
 * Exception that suggests to restart the application.
 */
public class SuggestRestartException extends CopilotException {

    /**
     * Creates a new exception with the given message.
     * 
     * @param message
     *            the message of the exception
     */
    public SuggestRestartException(String message) {
        super(message);
    }

    /**
     * Creates a new exception with the given cause.
     * 
     * @param cause
     *            the cause of the exception
     */
    public SuggestRestartException(Throwable cause) {
        super(cause);
    }

    /**
     * Creates a new exception with the given message and cause.
     * 
     * @param message
     *            the message of the exception
     * @param cause
     *            the cause of the exception
     */
    public SuggestRestartException(String message, Throwable cause) {
        super(message, cause);
    }
}
