package com.vaadin.copilot.plugins.themeeditor.handlers;

import com.vaadin.copilot.plugins.themeeditor.ThemeEditorCommand;
import com.vaadin.copilot.plugins.themeeditor.messages.BaseResponse;
import com.vaadin.copilot.plugins.themeeditor.messages.SetClassNameRequest;
import com.vaadin.copilot.plugins.themeeditor.utils.HasSourceModifier;
import com.vaadin.copilot.plugins.themeeditor.utils.HasThemeModifier;
import com.vaadin.copilot.plugins.themeeditor.utils.MessageHandler;
import com.vaadin.flow.internal.JsonUtils;

import elemental.json.JsonObject;

public class LocalClassNameHandler implements MessageHandler {

    private final HasSourceModifier hasSourceModifier;

    private final HasThemeModifier hasThemeModifier;

    public LocalClassNameHandler(HasSourceModifier hasSourceModifier, HasThemeModifier hasThemeModifier) {
        this.hasSourceModifier = hasSourceModifier;
        this.hasThemeModifier = hasThemeModifier;
    }

    @Override
    public BaseResponse handle(JsonObject data) {
        SetClassNameRequest request = JsonUtils.readToObject(data, SetClassNameRequest.class);

        // Flow
        if (request.isInstanceRequest()) {
            int uiId = request.getUiId();
            int nodeId = request.getNodeId();
            String currentLocalClassName = hasSourceModifier.getSourceModifier().getLocalClassName(uiId, nodeId);
            String tagName = hasSourceModifier.getSourceModifier().getTag(uiId, nodeId);
            // set classname in Java files
            hasSourceModifier.getSourceModifier().setLocalClassName(uiId, nodeId, request.getClassName());

            // update CSS if local classname already present
            if (currentLocalClassName != null) {
                hasThemeModifier.getThemeModifier().replaceClassName(tagName, currentLocalClassName,
                        request.getClassName());
            }

            return BaseResponse.ok();
        } else {
            // Hilla
            // update CSS if local classname already present
            if (request.getOldClassName() != null) {
                hasThemeModifier.getThemeModifier().replaceClassName(request.getTagName(), request.getOldClassName(),
                        request.getClassName());
            } else {
                // if not create an empty file
                hasThemeModifier.getThemeModifier().createEmptyStyleRule(null);
            }
            return BaseResponse.ok();
        }
    }

    @Override
    public String getCommandName() {
        return ThemeEditorCommand.LOCAL_CLASS_NAME.getValue();
    }
}
