package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.flow.internal.hilla.EndpointRequestUtil;
import com.vaadin.flow.server.VaadinServletContext;

import elemental.json.Json;
import elemental.json.JsonObject;

public class ProjectInfoHandler implements CopilotCommand {
    private final VaadinServletContext context;

    /**
     * Creates a new project info handler.
     *
     * @param context
     *            the servlet context to use
     */
    public ProjectInfoHandler(VaadinServletContext context) {
        this.context = context;
    }

    @Override
    public void handleConnect(DevToolsInterface devToolsInterface) {
        JsonObject data = Json.createObject();
        data.put("supportsHilla", EndpointRequestUtil.isHillaAvailable());
        if (SpringBridge.isSpringAvailable(context)) {
            data.put("springSecurityEnabled", SpringBridge.isSpringSecurityEnabled(context));
            data.put("urlPrefix", SpringBridge.getUrlPrefix(context));
            data.put("springJpaDataEnabled", SpringBridge.isSpringDataJpaAvailable(context));
        }

        devToolsInterface.send("copilot-early-project-state", data);

    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        return false;
    }
}
