package com.vaadin.copilot;

import com.vaadin.flow.server.VaadinServletContext;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.SecurityFilterChain;

/**
 * Provides Spring security related helpers for copilot. Depends on Spring
 * security classes and cannot be directly imported.
 */
public class SpringSecurityIntegration {

    private static Logger getLogger() {
        return LoggerFactory.getLogger(SpringSecurityIntegration.class);
    }

    /**
     * Checks whether Spring Security is enabled.
     *
     * @param context
     *            the Vaadin servlet context
     *
     * @return true if Spring Security is enabled, false otherwise
     */
    public static boolean isSpringSecurityEnabled(VaadinServletContext context) {
        try {
            String[] securityFilterChainBeanNames = SpringIntegration.getWebApplicationContext(context)
                    .getBeanNamesForType(SecurityFilterChain.class);
            return securityFilterChainBeanNames.length > 0;
        } catch (Exception e) {
            getLogger().trace("Exception while trying to find if Spring Security is enabled", e);
        }
        return false;
    }

}
