package com.vaadin.copilot.ai;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.Copilot;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.communication.CopilotServerResponseCode;
import com.vaadin.copilot.userinfo.DataCannotLeaveLocalhostException;

import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AICommunicationUtil {

    /**
     * Method handling the case when the AI cannot be called, because the proKey or
     * machineId is missing.
     *
     * @param data
     *            - the data object, we are getting from the client/browser
     * @param devToolsInterface
     *            - the devtools interface we use to communicate with the
     *            client/browser
     */
    public static void promptTextCannotCall(JsonObject data, DevToolsInterface devToolsInterface) {
        getLogger().error("Cannot call AI without a proKey or machineId present.");
        JsonObject responseData = Json.createObject();
        if (data.hasKey(CopilotCommand.KEY_REQ_ID)) {
            responseData.put(CopilotCommand.KEY_REQ_ID, data.getString(CopilotCommand.KEY_REQ_ID));
        }
        responseData.put("error", true);
        responseData.put("code", CopilotServerResponseCode.COPILOT_AUTHORISATION_FAILED.getCode());
        devToolsInterface.send(Copilot.PREFIX + AIConstants.MESSAGE_PROMPT_FAILED, responseData);
    }

    public static Map<String, String> getHillaSourceFiles(JsonObject data) {
        Map<String, String> sources = new LinkedHashMap<>();

        // Hilla source files;
        JsonArray reactSources = data.getArray("sources");
        if (reactSources != null) {
            for (int i = 0; i < reactSources.length(); i++) {
                JsonObject source = reactSources.getObject(i);
                getLogger().debug("Hilla file: {}", source.getString("filename"));
                sources.put(source.getString("filename"), source.getString("projectFile"));
            }
        }
        return sources;
    }

    public static void handlingExceptionsAndNotifyDevtoolsInterface(JsonObject dataJson,
            DevToolsInterface devToolsInterface, Throwable e) {
        JsonObject responseData = Json.createObject();
        if (dataJson.hasKey(CopilotCommand.KEY_REQ_ID)) {
            responseData.put(CopilotCommand.KEY_REQ_ID, dataJson.getString(CopilotCommand.KEY_REQ_ID));
        }
        if (e.getCause() instanceof TimeoutException) {
            responseData.put("code", AIConstants.COPILOT_CLIENT_TIMEOUT_ERROR);
        } else if (e instanceof DataCannotLeaveLocalhostException) {
            responseData.put("code", CopilotServerResponseCode.AI_DISABLED.getCode());
        } else {
            responseData.put("code", AIConstants.COPILOT_INTERNAL_ERROR);
        }
        responseData.put("message", "Error querying copilot server");
        getLogger().error("Error querying copilot server", e);
        devToolsInterface.send(Copilot.PREFIX + AIConstants.MESSAGE_PROMPT_FAILED, responseData);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(AICommunicationUtil.class);
    }
}
