package com.vaadin.copilot.userinfo;

/**
 * Thrown when the user tries to use some AI functionality but the data cannot
 * leave localhost.
 * <p>
 * Mostly should never be thrown as the UI should prevent the user from
 * triggering AI functionality in these cases.
 */
public class DataCannotLeaveLocalhostException extends RuntimeException {

    /**
     * Creates a new exception with the default message.
     */
    public DataCannotLeaveLocalhostException() {
        super("AI usage is disabled for this subscription");
    }
}
