package com.vaadin.copilot;

import java.io.IOException;
import java.nio.charset.StandardCharsets;

import com.vaadin.base.devserver.DevToolsInterface;

import elemental.json.Json;
import elemental.json.JsonObject;

import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MachineConfigurationHandler extends CopilotCommand {
    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("get-machine-configuration")) {
            JsonObject response = Json.createObject();
            response.put("conf", MachineConfiguration.get().getJson());
            devToolsInterface.send("copilot-machine-configuration", response);
            return true;
        } else if (command.equals("set-machine-configuration")) {
            try {
                String json = data.getString("conf");
                FileUtils.write(MachineConfiguration.getFile(), json + "\n", StandardCharsets.UTF_8);
                getLogger().debug("Writing configuration: {}", json);
            } catch (IOException e) {
                getLogger().error("Failed to write machine configuration", e);
            }
            return true;
        }
        return false;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(MachineConfigurationHandler.class);
    }

}
