package com.vaadin.copilot.javarewriter;

import java.io.File;
import java.util.Optional;

import com.github.javaparser.ast.stmt.BlockStmt;

/**
 * Holds information about a component's attachment within the Java source code.
 * <p>
 * This class extends {@link AbstractComponentLocationInfo} and adds details
 * specific to how and where a component is attached in the code, such as the
 * block scope for the attachment, whether it occurs in the same file as its
 * creation, and the attach call expression itself.
 * </p>
 */
public class ComponentAttachInfo extends AbstractComponentLocationInfo {
    private BlockStmt componentAttachScope;

    private AttachExpression attachCall;

    /**
     * Constructs a new {@code ComponentAttachInfo} with the given Java source and
     * file reference.
     *
     * @param javaSource
     *            the {@link JavaSource} representing the parsed source code where
     *            the component is defined; must not be {@code null}.
     * @param file
     *            the {@link File} object corresponding to the source file; must not
     *            be {@code null}.
     */
    public ComponentAttachInfo(JavaSource javaSource, File file) {
        super(javaSource, file);
    }

    public void setComponentAttachScope(BlockStmt componentAttachScope) {
        this.componentAttachScope = componentAttachScope;
    }

    public Optional<BlockStmt> getComponentAttachScope() {
        if (componentAttachScope == null) {
            return Optional.empty();
        }
        return Optional.of(componentAttachScope);
    }

    public AttachExpression getAttachCall() {
        return attachCall;
    }

    public void setAttachCall(AttachExpression attachCall) {
        this.attachCall = attachCall;
    }
}
