package com.vaadin.copilot.javarewriter.custom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.vaadin.copilot.JavaReflectionUtil;
import com.vaadin.copilot.javarewriter.ComponentInfo;
import com.vaadin.copilot.javarewriter.FlowComponentQuirks;
import com.vaadin.copilot.javarewriter.InsertionPoint;
import com.vaadin.copilot.javarewriter.JavaComponent;
import com.vaadin.copilot.javarewriter.JavaRewriter;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;

/**
 * CustomComponentHandle is the backbone of creating statement for custom
 * components such as Grids, Charts etc...
 */
public abstract class CustomComponentHandle {

    public abstract List<VariableDeclarator> createComponentStatements(JavaRewriter javaRewriter,
            JavaComponent component, InsertionPoint insertionPoint, JavaComponent parent, String layoutVariableName,
            ComponentInfo referenceComponent, JavaRewriter.AddTemplateOptions options);

    protected void insertSetter(JavaComponent javaComponent, ObjectCreationExpr constructor, JavaRewriter javaRewriter,
            CompilationUnit compilationUnit, String componentClassName, InsertionPoint insertionPoint,
            NameExpr variableNameExpr) {
        Map<String, Object> setters = new HashMap<>();
        ClassOrInterfaceType fullType = StaticJavaParser.parseClassOrInterfaceType(componentClassName);
        Class<?> componentType = JavaReflectionUtil.getClass(fullType.getNameWithScope());

        // Properties setters
        javaComponent.props().forEach((prop, value) -> {
            if (skipProps(javaComponent, prop)) {
                return;
            }
            JavaRewriter.SetterAndValue setterAndValue = JavaRewriterUtil.getSetterAndValue(componentType, prop, value);
            setters.put(setterAndValue.setter(), setterAndValue.value());
        });
        // Removes setter property to be used in constructor
        JavaRewriterUtil.getSingleStringParamConstructor(fullType, setters.keySet()).ifPresent(constructorProp -> {
            Object value = setters.remove(constructorProp);
            javaRewriter.getParameterList(insertionPoint, value).forEach(constructor::addArgument);
        });
        for (Map.Entry<String, Object> setter : setters.entrySet()) {
            Object value = setter.getValue();
            javaRewriter.insertSetter(insertionPoint, variableNameExpr, setter.getKey(), value, javaComponent);
        }
    }

    protected boolean skipProps(JavaComponent component, String prop) {
        return FlowComponentQuirks.skipProps(component, prop);
    }
}
