package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;

import elemental.json.Json;
import elemental.json.JsonObject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationUserSwitchHandler extends CopilotCommand {

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("switch-user")) {
            String reqId = data.getString(KEY_REQ_ID);
            JsonObject respData = Json.createObject();
            respData.put(KEY_REQ_ID, reqId);

            String username = data.getString("username");

            try {
                if (!SpringBridge.isSpringSecurityEnabled(getVaadinContext())) {
                    ErrorHandler.setErrorMessage(respData,
                            "This only works when Spring Security is in use in the project");
                } else {
                    SpringBridge.setActiveSpringSecurityUser(username, getVaadinSession());
                }
            } catch (Exception e) {
                if (e.getClass().getName()
                        .equals("org.springframework.security.core.userdetails.UsernameNotFoundException")) {
                    ErrorHandler.sendErrorResponse(devToolsInterface, command, respData, "Username not found", e);
                } else {
                    ErrorHandler.sendErrorResponse(devToolsInterface, command, respData, "Unable to switch user", e);
                    getLogger().error("Unable to switch user", e);
                }
                return true;
            }
            devToolsInterface.send(command + "-response", respData);
            return true;
        }
        return false;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(getClass());
    }

}
