package com.vaadin.copilot;

import java.util.Properties;

/** Utility class for reading the Copilot version. */
public final class CopilotVersion {

    private static final String VERSION;

    private CopilotVersion() {
        // Only utils
    }

    static {
        Properties properties = new Properties();
        try {
            properties.load(CopilotVersion.class.getResourceAsStream("copilot.properties"));
        } catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }

        VERSION = properties.getProperty("copilot.version");
    }

    public static String getVersion() {
        return VERSION;
    }
}
