package com.vaadin.copilot;

import jakarta.persistence.EntityManager;
import jakarta.persistence.metamodel.EntityType;

import java.util.List;
import java.util.Set;

import com.vaadin.flow.server.VaadinServletContext;

public class SpringDataIntegration {

    public static List<Class<?>> getJpaEntityClasses(VaadinServletContext context) {
        EntityManager entityManager = SpringIntegration.getWebApplicationContext(context).getBean(EntityManager.class);
        Set<EntityType<?>> entityTypes = entityManager.getMetamodel().getEntities();
        return (List) entityTypes.stream().map((entityType -> entityType.getJavaType())).toList();
    }
}
