package com.vaadin.copilot.customcomponent;

import java.util.List;

/**
 * Contains information about custom component instance.
 */
public class CustomComponentInstanceInfo extends ComponentInfoForCustomComponentSupport {
    private CustomComponent.Type type;
    private String activeLevel;
    private final String javaClassName;
    private final List<CustomComponentAddMethodInfo> addMethodInfoList;
    private final String customComponentFilePath;

    public CustomComponentInstanceInfo(CustomComponent.Type type, String activeLevel,
            List<CustomComponentAddMethodInfo> addMethodInfoList, String javaClassName,
            String customComponentFilePath) {
        this.type = type;
        this.activeLevel = activeLevel;
        this.addMethodInfoList = List.copyOf(addMethodInfoList);
        this.javaClassName = javaClassName;
        this.customComponentFilePath = customComponentFilePath;
    }

    public CustomComponent.Type getType() {
        return type;
    }

    public void setType(CustomComponent.Type type) {
        this.type = type;
    }

    public String getActiveLevel() {
        return activeLevel;
    }

    public void setActiveLevel(String activeLevel) {
        this.activeLevel = activeLevel;
    }

    public List<CustomComponentAddMethodInfo> getAddMethodInfoList() {
        return addMethodInfoList;
    }

    public String getJavaClassName() {
        return javaClassName;
    }

    public String getCustomComponentFilePath() {
        return customComponentFilePath;
    }
}
