package com.vaadin.copilot.javarewriter;

import java.io.File;
import java.util.Optional;

import com.github.javaparser.ast.stmt.BlockStmt;

/**
 * Holds metadata related to the attachment of a component in a Java source
 * file.
 * <p>
 * This record encapsulates the source context, the file, the specific attach
 * expression, and scope information for the component being attached.
 *
 * @param javaSource
 *            the {@link JavaSource} representing the source code where the
 *            attachment occurs
 * @param file
 *            the {@link File} object pointing to the source file containing the
 *            attachment
 * @param attachCall
 *            the {@link AttachExpression} representing the method call or
 *            expression that performs the attachment
 * @param componentAttachScope
 *            an {@link Optional} containing the {@link BlockStmt} that defines
 *            the scope of the component attachment, if available
 * @param inSameFileWithCreateLocation
 *            {@code true} if the component's creation and attachment occur in
 *            the same file, {@code false} otherwise
 */
public record ComponentAttachInfo(JavaSource javaSource, File file, AttachExpression attachCall,
        Optional<BlockStmt> componentAttachScope, boolean inSameFileWithCreateLocation) {
}
