package com.vaadin.copilot;

import java.io.File;

import com.vaadin.base.devserver.DevToolsInterface;

import elemental.json.JsonObject;

/**
 * Handler for stored project state configuration operations.
 */
public class ProjectStateConfigurationHandler extends CopilotCommand {

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("get-project-state-configuration")) {
            JsonObject response = ConfigurationFileUtil.getConfigResponse(getConfigFile());
            devToolsInterface.send("copilot-project-state-configuration", response);
            return true;
        } else if (command.equals("set-project-state-configuration")) {
            ConfigurationFileUtil.saveConfigFromRequest(getConfigFile(), data);
            return true;
        }
        return false;
    }

    private File getConfigFile() {
        return new File(getProjectFileManager().getProjectRoot(), "vaadin-copilot.json");
    }
}
