package com.vaadin.copilot.customcomponent;

import java.io.File;

/**
 * Contains information for custom components that are found in project sources.
 *
 * @param componentClass
 *            Class instance of custom component
 * @param sourceFile
 *            Source file in the project
 */
public record CustomComponentInProject(Class<?> componentClass, File sourceFile) implements CustomComponent {

    @Override
    public Type getType() {
        return Type.IN_PROJECT;
    }
}
