package com.vaadin.copilot.javarewriter;

import java.io.File;

/**
 * Represents metadata related to the creation of a component within a Java
 * source file.
 * <p>
 * This record holds the source context and the corresponding file where the
 * component is created.
 *
 * @param javaSource
 *            the {@link JavaSource} representing the source code containing the
 *            component creation
 * @param file
 *            the {@link File} object referring to the source file where the
 *            component is created
 */
public record ComponentCreateInfo(JavaSource javaSource, File file) {
}
