package com.vaadin.copilot.javarewriter;

import java.util.Optional;

import com.vaadin.copilot.customcomponent.CustomComponent;
import com.vaadin.flow.component.Component;

import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;

/**
 * Builder pattern for {@link ComponentInfo} class
 */
public class ComponentInfoBuilder {
    private Class<? extends Component> type;
    private ObjectCreationExpr objectCreationExpr;
    private BlockStmt componentCreateScope;
    private VariableDeclarator localVariableDeclarator;
    private AssignExpr assignmentExpression;
    private FieldDeclaration fieldDeclaration;
    private FieldDeclaration fieldDeclarationAndAssignment;
    private String localVariableName;
    private String fieldName;
    private ConstructorDeclaration routeConstructor;
    private boolean containerComposite;
    private boolean isAnonymousComponent;
    private boolean isReturnValue;
    private boolean classSource;
    private CustomComponent customComponentInfo = null;

    private Optional<ComponentAttachInfo> attachInfo = Optional.empty();
    private Optional<ComponentCreateInfo> createInfo = Optional.empty();

    public ComponentInfoBuilder setType(Class<? extends Component> type) {
        this.type = type;
        return this;
    }

    public ComponentInfoBuilder setObjectCreationExpr(ObjectCreationExpr objectCreationExpr) {
        this.objectCreationExpr = objectCreationExpr;
        return this;
    }

    public ComponentInfoBuilder setComponentCreateScope(BlockStmt componentCreateScope) {
        this.componentCreateScope = componentCreateScope;
        return this;
    }

    public ComponentInfoBuilder setAttachInfo(ComponentAttachInfo attachInfo) {
        if (attachInfo == null) {
            this.attachInfo = Optional.empty();
        } else {
            this.attachInfo = Optional.of(attachInfo);
        }
        return this;
    }

    public ComponentInfoBuilder setCreateInfo(ComponentCreateInfo componentCreateInfo) {
        if (componentCreateInfo == null) {
            this.createInfo = Optional.empty();
        } else {
            this.createInfo = Optional.of(componentCreateInfo);
        }
        return this;
    }

    public ComponentInfoBuilder setLocalVariableDeclarator(VariableDeclarator localVariableDeclarator) {
        this.localVariableDeclarator = localVariableDeclarator;
        return this;
    }

    public ComponentInfoBuilder setAssignmentExpression(AssignExpr assignmentExpression) {
        this.assignmentExpression = assignmentExpression;
        return this;
    }

    public ComponentInfoBuilder setFieldDeclaration(FieldDeclaration fieldDeclaration) {
        this.fieldDeclaration = fieldDeclaration;
        return this;
    }

    public ComponentInfoBuilder setFieldDeclarationAndAssignment(FieldDeclaration fieldDeclarationAndAssignment) {
        this.fieldDeclarationAndAssignment = fieldDeclarationAndAssignment;
        return this;
    }

    public ComponentInfoBuilder setLocalVariableName(String localVariableName) {
        this.localVariableName = localVariableName;
        return this;
    }

    public ComponentInfoBuilder setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public ComponentInfoBuilder setRouteConstructor(ConstructorDeclaration routeConstructor) {
        this.routeConstructor = routeConstructor;
        return this;
    }

    public ComponentInfoBuilder setContainerComposite(boolean containerComposite) {
        this.containerComposite = containerComposite;
        return this;
    }

    public ComponentInfoBuilder setAnonymousComponent(boolean anonymousComponent) {
        isAnonymousComponent = anonymousComponent;
        return this;
    }

    public ComponentInfoBuilder setReturnValue(boolean returnValue) {
        isReturnValue = returnValue;
        return this;
    }

    public ComponentInfoBuilder setCustomComponentInfo(CustomComponent customComponentInfo) {
        this.customComponentInfo = customComponentInfo;
        return this;
    }

    public ComponentInfoBuilder setClassSource(boolean classSource) {
        this.classSource = classSource;
        return this;
    }

    public String getLocalVariableName() {
        return localVariableName;
    }

    public String getFieldName() {
        return fieldName;
    }

    public ObjectCreationExpr getObjectCreationExpr() {
        return objectCreationExpr;
    }

    public boolean isClassSource() {
        return classSource;
    }

    public ComponentInfo build() {
        return new ComponentInfo(type, objectCreationExpr, componentCreateScope, localVariableDeclarator,
                assignmentExpression, fieldDeclaration, fieldDeclarationAndAssignment, localVariableName, fieldName,
                routeConstructor, containerComposite, isAnonymousComponent, isReturnValue,
                Optional.ofNullable(customComponentInfo), attachInfo, createInfo);
    }
}
