package com.vaadin.copilot;

import java.util.List;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.internal.hilla.EndpointRequestUtil;

import elemental.json.Json;
import elemental.json.JsonObject;

public class ProjectInfoHandler extends CopilotCommand {

    @Override
    public void handleConnect(DevToolsInterface devToolsInterface) {
        JsonObject data = Json.createObject();
        data.put("supportsHilla", EndpointRequestUtil.isHillaAvailable());
        if (SpringBridge.isSpringAvailable(getVaadinContext())) {
            data.put("springSecurityEnabled", SpringBridge.isSpringSecurityEnabled(getVaadinContext()));
            data.put("urlPrefix", SpringBridge.getUrlPrefix(getVaadinContext()));
            data.put("springJpaDataEnabled", SpringBridge.isSpringDataJpaAvailable(getVaadinContext()));
        }

        devToolsInterface.send("copilot-early-project-state", data);

    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {

        if (command.equals("get-project-info")) {
            JsonObject responseData = Json.createObject();
            responseData.put(KEY_REQ_ID, data.getString(KEY_REQ_ID));

            if (SpringBridge.isSpringAvailable(getVaadinContext())) {
                List<? extends Class<?>> jpaEntityClasses = SpringBridge.getJpaEntityClasses(getVaadinContext());
                responseData.put("jpaEntityClasses",
                        JsonUtils.listToJson(jpaEntityClasses.stream().map(Class::getName).toList()));
            }
            devToolsInterface.send(command + "-response", responseData);
            return true;
        }
        return false;
    }
}
