package com.vaadin.copilot.ai;

import java.util.Base64;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.CopilotServerClient;
import com.vaadin.copilot.userinfo.UserInfoServerClient;

import elemental.json.Json;
import elemental.json.JsonObject;

public class CreateLumoThemeVariablesHandler extends CopilotCommand {

    private final CopilotServerClient copilotServerClient = new CopilotServerClient();

    public record CreateLumoThemeVariableData(byte[] imageData, String mimeType) {
    }

    public record CreateLumoThemeVariableRequest(CreateLumoThemeVariableData data,
            CopilotServerClient.AccessControlData accessControlData) {
    }

    public record CreateLumoThemeVariableResponse(String css) {
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("ai-create-lumo-theme-variables")) {
            UserInfoServerClient.throwIfAIUsageDisabled();
            JsonObject respData = Json.createObject();
            respData.put(CopilotCommand.KEY_REQ_ID, data.getString(CopilotCommand.KEY_REQ_ID));

            byte[] imageData = Base64.getDecoder().decode(data.getString("imageBase64"));
            CreateLumoThemeVariableRequest request = new CreateLumoThemeVariableRequest(
                    new CreateLumoThemeVariableData(imageData, data.getString("imageMimeType")),
                    CopilotServerClient.AccessControlData.create());

            copilotServerClient.sendCopilotRequest("create-lumo-theme-variables", request,
                    CreateLumoThemeVariableResponse.class, response -> {
                        respData.put("css", response.css());
                        devToolsInterface.send(command + "-resp", respData);
                    }, devToolsInterface, command, respData);
            return true;
        }
        return false;
    }

}