package com.vaadin.copilot.javarewriter;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.vaadin.copilot.CopilotException;

import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.ObjectCreationExpr;

/**
 * JavaBatchRewriter handles java file modifications for multiple Components.
 *
 * @deprecated It is deprecated and needs to be removed because JavaRewriter and
 *             CompilationUnit have been decoupled in recent changes.
 */
@Deprecated(forRemoval = true)
public class JavaBatchRewriter {
    private final Map<ComponentTypeAndSourceLocation, ComponentInfo> components;
    private final JavaFileSourceProvider javaFileSourceProvider;

    public JavaBatchRewriter(JavaFileSourceProvider javaFileSourceProvider,
            List<ComponentTypeAndSourceLocation> componentLocations) {
        this.javaFileSourceProvider = javaFileSourceProvider;
        // Parse all needed Java files
        Stream<ComponentTypeAndSourceLocation> componentsInSource = componentLocations.stream()
                .filter(componentTypeAndSourceLocation -> componentTypeAndSourceLocation.javaFile().isPresent())
                .distinct();

        this.components = componentsInSource.collect(Collectors.toMap(component -> component, component -> {
            try {
                return new ComponentInfoFinder(javaFileSourceProvider, component).find();
            } catch (IOException e) {
                throw new CopilotException(e);
            }
        }));
    }

    public void duplicate(ComponentTypeAndSourceLocation componentSource) {
        ComponentInfo component = components.get(componentSource);
        if (component == null) {
            throw new IllegalArgumentException("The component to be duplicated must be included in the "
                    + getClass().getSimpleName() + " constructor call");
        }
        if (component.routeConstructor() != null) {
            throw new IllegalArgumentException("Routes cannot be duplicated.");
        }

        duplicateComponent(componentSource, component, true);
    }

    private JavaRewriter.DuplicateInfo duplicateComponent(ComponentTypeAndSourceLocation componentSource,
            ComponentInfo component, boolean attachIt) {
        // Duplicate this component first in a normal way
        JavaRewriter rewriter = new JavaRewriter();
        JavaRewriter.DuplicateInfo result = rewriter.duplicate(component, attachIt);

        for (ComponentTypeAndSourceLocation child : componentSource.children()) {
            ComponentInfo childComponent = components.get(child);

            if (childComponent == null || childComponent.isAnonymousComponent()) {
                continue;
            }

            JavaRewriter.DuplicateInfo childResult = duplicateComponent(child, childComponent, false);

            // Fix attach calls for the children
            for (Map.Entry<String, String> entry : childResult.nameMapping().entrySet()) {
                String oldName = entry.getKey();
                String newName = entry.getValue();

                result.childAddCalls().forEach(addCall -> rewriter.replaceCallParameter(addCall, oldName, newName));
                // Fix the name if the child is attached in the constructor
                if (childComponent.getAttachCallInSameFileOrThrow().getObjectCreationExpression() != null) {
                    // The parent is a variable
                    if (result.variableDeclaration() != null
                            && result.variableDeclaration().getVariables().isNonEmpty()) {
                        Expression vd = result.variableDeclaration().getVariable(0).getInitializer().orElse(null);
                        if (vd != null && vd.isObjectCreationExpr()) {
                            rewriter.replaceCallParameter(vd.asObjectCreationExpr(), oldName, newName);
                        }
                    } // The parent is a field
                    else if (result.assignExpr() != null && result.assignExpr().getValue() != null
                            && result.assignExpr().getValue().isObjectCreationExpr()) {
                        ObjectCreationExpr parentObjectCreationExpr = result.assignExpr().getValue()
                                .asObjectCreationExpr();
                        rewriter.replaceCallParameter(parentObjectCreationExpr, oldName, newName);
                    }
                }
            }
        }
        return result;
    }

    public interface Callback {
        void accept(ComponentTypeAndSourceLocation source, ComponentInfo component, JavaRewriter rewriter);
    }

    public void forEachComponent(Callback cb) {
        components.forEach((source, component) -> {
            JavaRewriter javaRewriter = new JavaRewriter();
            cb.accept(source, component, javaRewriter);
        });
    }

    public Map<File, String> getResults() {
        Map<File, String> results = new LinkedHashMap<>();
        for (ComponentInfo componentInfo : components.values()) {
            File file = componentInfo.getCreateLocationFileOrThrowIfNull();
            if (!results.containsKey(file)) {
                String result = componentInfo.componentCreateInfoOptional()
                        .orElseThrow(() -> new IllegalStateException("No component created for " + componentInfo))
                        .getJavaSource().getResult();
                results.put(file, result);
            }
        }
        return results;
    }

    public void writeResult() {
        components.values().forEach(javaFileSourceProvider::saveComponentInfoSourceFiles);
    }

}
