package com.vaadin.copilot.javarewriter.custom;

import java.util.List;
import java.util.Map;

import com.vaadin.copilot.javarewriter.ComponentInfo;
import com.vaadin.copilot.javarewriter.FlowComponentQuirks;
import com.vaadin.copilot.javarewriter.InsertionPoint;
import com.vaadin.copilot.javarewriter.JavaComponent;
import com.vaadin.copilot.javarewriter.JavaRewriter;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import com.vaadin.copilot.javarewriter.JavaSource;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;

public class DetailsComponentHandle extends CustomComponentHandle {
    private static final String SUMMARY = "summary";
    private static final String SUMMARY_TEXT = "text";

    @Override
    public List<VariableDeclarator> createComponentStatements(JavaRewriter javaRewriter, JavaComponent component,
            InsertionPoint insertionPoint, JavaComponent parent, String layoutVariableName,
            ComponentInfo referenceComponent, JavaRewriter.AddTemplateOptions options, JavaSource javaSource) {
        CompilationUnit compilationUnit = insertionPoint.getCompilationUnit();
        String componentClassName = FlowComponentQuirks.getClassForComponent(component);
        ClassOrInterfaceType fullType = StaticJavaParser.parseClassOrInterfaceType(componentClassName); // Import
        JavaRewriterUtil.addImport(compilationUnit, fullType.getNameWithScope());

        String detailsVariableName = JavaRewriterUtil.generateVariableName(component, fullType, insertionPoint);

        VariableDeclarator detailsVarDeclarator = new VariableDeclarator(fullType.removeScope(), detailsVariableName);

        ObjectCreationExpr detailsCreationExpr = new ObjectCreationExpr();
        detailsCreationExpr.setType(fullType.removeScope());

        Map<String, Object> props = component.props();
        if (props.containsKey(SUMMARY)) {
            detailsCreationExpr.addArgument(new StringLiteralExpr((String) props.get(SUMMARY)));
        }

        detailsVarDeclarator.setInitializer(detailsCreationExpr);
        VariableDeclarationExpr detailsVarDeclaration = new VariableDeclarationExpr(detailsVarDeclarator);
        insertionPoint.add(new ExpressionStmt(detailsVarDeclaration));

        if (props.containsKey(SUMMARY_TEXT)) {
            // plain text as content
            MethodCallExpr methodCallExpr = new MethodCallExpr("add");
            methodCallExpr.setScope(new NameExpr(detailsVariableName));
            methodCallExpr.addArgument(new StringLiteralExpr((String) props.get(SUMMARY_TEXT)));
            insertionPoint.add(new ExpressionStmt(methodCallExpr));
            addOpenedMethodCall(detailsVariableName, insertionPoint);
        }

        insertSetter(component, detailsCreationExpr, javaRewriter, componentClassName, insertionPoint,
                new NameExpr(detailsVariableName), javaSource);

        if (!component.children().isEmpty()) {
            javaRewriter.createComponentStatements(insertionPoint, component, component.children(), detailsVariableName,
                    null, options, null, javaSource);
            addOpenedMethodCall(detailsVariableName, insertionPoint);
        }

        javaRewriter.attachComponent(insertionPoint, component, parent, layoutVariableName, referenceComponent,
                new NameExpr(detailsVariableName), detailsVariableName, options, null);

        return List.of(detailsVarDeclarator);
    }

    @Override
    protected boolean skipProps(JavaComponent component, String prop) {
        return super.skipProps(component, prop) || prop.equals(SUMMARY) || prop.equals(SUMMARY_TEXT);
    }

    private void addOpenedMethodCall(String detailsVariableName, InsertionPoint insertionPoint) {
        MethodCallExpr openExpression = new MethodCallExpr("setOpened");
        openExpression.setScope(new NameExpr(detailsVariableName));
        openExpression.addArgument(new BooleanLiteralExpr(true));
        insertionPoint.add(new ExpressionStmt(openExpression));
    }
}
