/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.exampledata;

import com.vaadin.exampledata.DataType;
import java.time.LocalDateTime;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CombinedStringGenerator
extends DataType<String> {
    private DataType<String>[] generators;
    private boolean sameSeed;
    private int seedOffset = 0;

    @SafeVarargs
    public CombinedStringGenerator(DataType<String> ... generators) {
        this(true, 0, generators);
    }

    @SafeVarargs
    public CombinedStringGenerator(boolean sameSeed, int seedOffset, DataType<String> ... generators) {
        this.seedOffset = seedOffset;
        this.generators = generators;
        this.sameSeed = sameSeed;
    }

    @Override
    public String getValue(Random random, int seed, LocalDateTime referenceTime) {
        seed += this.seedOffset;
        Stream.Builder<String> values = Stream.builder();
        for (DataType<String> generator : this.generators) {
            String value = generator.getValue(random, seed, referenceTime);
            values.add(value);
            if (this.sameSeed) continue;
            ++seed;
        }
        return values.build().collect(Collectors.joining(" "));
    }
}

