/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.exampledata;

import com.vaadin.exampledata.DataType;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiConsumer;

public class ExampleDataGenerator<T> {
    private Class<T> type;
    private Random random = new Random();
    private Map<BiConsumer<T, ?>, DataType<?>> setters = new LinkedHashMap();
    private LocalDateTime referenceTime;

    @Deprecated
    public ExampleDataGenerator(Class<T> type) {
        this(type, LocalDateTime.now());
    }

    public ExampleDataGenerator(Class<T> type, LocalDateTime referenceTime) {
        this.type = type;
        this.referenceTime = referenceTime;
    }

    public <F> void setData(BiConsumer<T, F> setter, DataType<F> dataType) {
        this.setters.put(setter, dataType);
    }

    public T createBean(int seed) {
        try {
            T bean = this.type.newInstance();
            for (Map.Entry<BiConsumer<T, ?>, DataType<?>> entry : this.setters.entrySet()) {
                this.assignValue(bean, entry.getKey(), entry.getValue(), seed);
            }
            return bean;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create bean instance of type " + this.type.getName(), e);
        }
    }

    private <F> void assignValue(T bean, BiConsumer<T, F> setter, DataType<F> dataType, int seed) {
        setter.accept(bean, dataType.getValue(this.random, seed, this.referenceTime));
    }

    public List<T> create(int count, int seed) {
        ArrayList<T> beans = new ArrayList<T>();
        for (int i = 0; i < count; ++i) {
            beans.add(this.createBean(seed + i));
        }
        return beans;
    }
}

