/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.exampledata;

import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeUtil {
    private Process nodeProcess = null;
    private PrintWriter nodeWriter;
    private Scanner nodeScanner;

    public void initialize(String initScript) throws InterruptedException, IOException {
        if (this.nodeProcess != null) {
            return;
        }
        this.runScript(initScript);
    }

    public synchronized String runScript(String script) throws InterruptedException, IOException {
        if (this.nodeProcess == null) {
            NodeUtil.getLogger().debug("Node is not running, finding binary");
            FrontendTools tools = new FrontendTools("", () -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath());
            String node = tools.getNodeExecutable();
            NodeUtil.getLogger().debug("Node is at '{}'", (Object)node);
            ArrayList<String> command = new ArrayList<String>();
            command.add(node);
            command.add("-i");
            ProcessBuilder builder = FrontendUtils.createProcessBuilder(command);
            this.nodeProcess = builder.start();
            this.nodeWriter = new PrintWriter(this.nodeProcess.getOutputStream(), true);
            InputStreamReader reader = new InputStreamReader(this.nodeProcess.getInputStream(), "UTF-8");
            boolean skipToken = true;
            if (reader.read() == 62) {
                NodeUtil.getLogger().debug("First output is '>', assuming Node 10");
                reader.read();
                skipToken = false;
            }
            this.nodeScanner = new Scanner(reader);
            this.nodeScanner.useDelimiter("> ");
            if (skipToken) {
                NodeUtil.getLogger().debug("Skipping initial token");
                String token = this.nodeScanner.next();
                NodeUtil.getLogger().debug("Skipped: " + token);
            }
        }
        NodeUtil.getLogger().debug("Executing script: '{}'", (Object)script);
        this.nodeWriter.println(script);
        String token = this.nodeScanner.next();
        NodeUtil.getLogger().debug("Got token: '{}'", (Object)token);
        String value = token.replaceAll("[\r\n]*$", "");
        NodeUtil.getLogger().debug("Returning: '{}'", (Object)value);
        return value;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(NodeUtil.class);
    }
}

