/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereServlet;

public class AtmosphereFrameworkInitializer {
    protected static final Logger logger = LoggerFactory.getLogger(AtmosphereFrameworkInitializer.class);
    protected AtmosphereFramework framework;
    protected boolean isFilter;
    protected boolean autoDetectHandlers;

    public AtmosphereFrameworkInitializer(boolean isFilter, boolean autoDetectHandlers) {
        this.isFilter = isFilter;
        this.autoDetectHandlers = autoDetectHandlers;
    }

    public AtmosphereFrameworkInitializer configureFramework(ServletConfig sc) throws ServletException {
        return this.configureFramework(sc, true, false);
    }

    public AtmosphereFrameworkInitializer configureFramework(ServletConfig sc, boolean init, boolean useNative) throws ServletException {
        if (this.framework == null) {
            if (sc.getServletContext().getMajorVersion() > 2) {
                try {
                    this.framework = (AtmosphereFramework)sc.getServletContext().getAttribute(sc.getServletContext().getServletRegistration(sc.getServletName()).getName());
                }
                catch (Exception ex) {
                    if (UnsupportedOperationException.class.isAssignableFrom(ex.getClass())) {
                        logger.warn("WebLogic 12c unable to retrieve Servlet. Please make sure your servlet-name is 'AtmosphereServlet' or set org.atmosphere.servlet to the current value");
                        String name = sc.getInitParameter("org.atmosphere.servlet");
                        if (name == null) {
                            name = AtmosphereServlet.class.getSimpleName();
                        }
                        this.framework = (AtmosphereFramework)sc.getServletContext().getAttribute(name);
                    }
                    logger.trace("", (Throwable)ex);
                }
            }
            if (this.framework == null) {
                this.framework = this.newAtmosphereFramework();
            }
        }
        this.framework.setUseNativeImplementation(useNative);
        if (init) {
            this.framework.init(sc);
        }
        return this;
    }

    protected AtmosphereFramework newAtmosphereFramework() {
        return new AtmosphereFramework(this.isFilter, this.autoDetectHandlers);
    }

    public AtmosphereFramework framework() {
        if (this.framework == null) {
            this.framework = this.newAtmosphereFramework();
        }
        return this.framework;
    }

    public void destroy() {
        if (this.framework != null) {
            this.framework.destroy();
            this.framework = null;
        }
    }
}

