/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpSession;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereRequestImpl;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.AtmosphereResponseImpl;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.cpr.HeartbeatAtmosphereResourceEvent;
import org.atmosphere.cpr.Meteor;
import org.atmosphere.cpr.Serializer;
import org.atmosphere.cpr.SessionTimeoutSupport;
import org.atmosphere.interceptor.AllowInterceptor;
import org.atmosphere.util.Utils;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketEventListener;

public class AtmosphereResourceImpl
implements AtmosphereResource {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereResourceImpl.class);
    public static final String PRE_SUSPEND = AtmosphereResourceImpl.class.getName() + ".preSuspend";
    public static final String SKIP_BROADCASTER_CREATION = AtmosphereResourceImpl.class.getName() + ".skipBroadcasterCreation";
    public static final String METEOR = Meteor.class.getName();
    private AtmosphereRequest req;
    private AtmosphereResponse response;
    private final Action action = new Action();
    protected final List<Broadcaster> broadcasters = new CopyOnWriteArrayList<Broadcaster>();
    protected Broadcaster broadcaster;
    private AtmosphereConfig config;
    protected AsyncSupport asyncSupport;
    private Serializer serializer;
    private final AtomicBoolean isInScope = new AtomicBoolean(true);
    private AtmosphereResourceEventImpl event;
    private final AtomicBoolean isResumed = new AtomicBoolean();
    private final AtomicBoolean isCancelled = new AtomicBoolean();
    private final AtomicBoolean resumeOnBroadcast = new AtomicBoolean();
    private Object writeOnTimeout;
    private boolean disableSuspend;
    private final AtomicBoolean disconnected = new AtomicBoolean();
    private final ConcurrentLinkedQueue<AtmosphereResourceEventListener> listeners = new ConcurrentLinkedQueue();
    private final AtomicBoolean isSuspendEvent = new AtomicBoolean();
    private AtmosphereHandler atmosphereHandler;
    private String uuid;
    protected HttpSession session;
    private boolean disableSuspendEvent;
    private AtmosphereResource.TRANSPORT transport;
    private boolean forceBinaryWrite;
    private final AtomicBoolean suspended = new AtomicBoolean();
    private WebSocket webSocket;
    private final AtomicBoolean inClosingPhase = new AtomicBoolean();
    private boolean closeOnCancel;
    private final AtomicBoolean isPendingClose = new AtomicBoolean();

    public AtmosphereResourceImpl() {
    }

    @Deprecated
    public AtmosphereResourceImpl(AtmosphereConfig config, Broadcaster broadcaster, AtmosphereRequest req, AtmosphereResponse response, AsyncSupport asyncSupport, AtmosphereHandler atmosphereHandler) {
        this.initialize(config, broadcaster, req, response, asyncSupport, atmosphereHandler);
    }

    @Override
    public AtmosphereResource initialize(AtmosphereConfig config, Broadcaster broadcaster, AtmosphereRequest req, AtmosphereResponse response, AsyncSupport asyncSupport, AtmosphereHandler atmosphereHandler) {
        this.req = req;
        this.response = response;
        this.config = config;
        this.asyncSupport = asyncSupport;
        this.atmosphereHandler = atmosphereHandler;
        this.event = new AtmosphereResourceEventImpl(this);
        this.broadcaster = broadcaster;
        this.uniqueBroadcaster(broadcaster);
        String s = (String)req.getAttribute("org.atmosphere.cpr.AtmosphereResource.suspended.uuid");
        if (s == null && (s = response.getHeader("X-Atmosphere-tracking-id")) == null && req != null) {
            String tmp = req.getHeader("X-Atmosphere-tracking-id");
            s = tmp != null && !tmp.equalsIgnoreCase("0") ? tmp : null;
        }
        String string = this.uuid = s == null ? config.uuidProvider().generateUuid() : s;
        if (config.isSupportSession()) {
            try {
                this.session = req.getSession(config.getInitParameter("org.atmosphere.cpr.sessionCreate", true));
            }
            catch (NullPointerException ex) {
                logger.trace("http://java.net/jira/browse/GLASSFISH-18856", (Throwable)ex);
            }
        }
        this.transport = this.configureTransport();
        this.closeOnCancel = config.getInitParameter("org.atmosphere.cpr.AsynchronousProcessor.closeOnCancel", false);
        return this;
    }

    protected void register() {
        if (!Utils.pollableTransport(this.transport()) && !Utils.webSocketMessage(this)) {
            this.config.resourcesFactory().registerUuidForFindCandidate(this);
        }
    }

    private AtmosphereResource.TRANSPORT configureTransport() {
        if (this.req == null) {
            return AtmosphereResource.TRANSPORT.UNDEFINED;
        }
        String s = this.req.getHeader("X-Atmosphere-Transport");
        if (s == null) {
            return AtmosphereResource.TRANSPORT.UNDEFINED;
        }
        if (s.equals(AtmosphereResource.TRANSPORT.UNDEFINED.name()) && Utils.rawWebSocket(this.req)) {
            return AtmosphereResource.TRANSPORT.WEBSOCKET;
        }
        s = s.replace("-", "_").toUpperCase();
        if (AtmosphereResource.TRANSPORT.POLLING.name().equals(s)) {
            return AtmosphereResource.TRANSPORT.POLLING;
        }
        if (AtmosphereResource.TRANSPORT.LONG_POLLING.name().equals(s)) {
            return AtmosphereResource.TRANSPORT.LONG_POLLING;
        }
        if (AtmosphereResource.TRANSPORT.STREAMING.name().equals(s)) {
            return AtmosphereResource.TRANSPORT.STREAMING;
        }
        if (AtmosphereResource.TRANSPORT.JSONP.name().equals(s)) {
            return AtmosphereResource.TRANSPORT.JSONP;
        }
        if (AtmosphereResource.TRANSPORT.WEBSOCKET.name().equals(s)) {
            return AtmosphereResource.TRANSPORT.WEBSOCKET;
        }
        if (AtmosphereResource.TRANSPORT.SSE.name().equals(s)) {
            return AtmosphereResource.TRANSPORT.SSE;
        }
        if (AtmosphereResource.TRANSPORT.AJAX.name().equals(s)) {
            return AtmosphereResource.TRANSPORT.AJAX;
        }
        if (AtmosphereResource.TRANSPORT.CLOSE.name().equals(s)) {
            return AtmosphereResource.TRANSPORT.CLOSE;
        }
        return AtmosphereResource.TRANSPORT.UNDEFINED;
    }

    @Override
    public AtmosphereResourceEventImpl getAtmosphereResourceEvent() {
        return this.event;
    }

    @Override
    public AtmosphereHandler getAtmosphereHandler() {
        return this.atmosphereHandler;
    }

    @Override
    public AtmosphereResource writeOnTimeout(Object o) {
        this.writeOnTimeout = o;
        return this;
    }

    @Override
    public Object writeOnTimeout() {
        return this.writeOnTimeout;
    }

    @Override
    public String uuid() {
        return this.uuid;
    }

    @Override
    public AtmosphereResource.TRANSPORT transport() {
        return this.transport;
    }

    public AtmosphereResourceImpl transport(AtmosphereResource.TRANSPORT transport) {
        this.transport = transport;
        return this;
    }

    @Override
    public AtmosphereResource resumeOnBroadcast(boolean resumeOnBroadcast) {
        this.resumeOnBroadcast.set(resumeOnBroadcast);
        this.req.setAttribute("org.atmosphere.resumeOnBroadcast", resumeOnBroadcast);
        return this;
    }

    @Override
    public boolean isSuspended() {
        return this.suspended.get();
    }

    @Override
    public boolean resumeOnBroadcast() {
        boolean rob = this.resumeOnBroadcast.get();
        if (!rob) {
            try {
                Boolean b = (Boolean)this.req.getAttribute("org.atmosphere.resumeOnBroadcast");
                return b == null ? false : b;
            }
            catch (ClassCastException ex) {
                return false;
            }
        }
        return rob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AtmosphereResource resume() {
        block13: {
            if (!this.isSuspended()) {
                logger.trace("AtmosphereResource {} not suspended {}, cannot resume it.", (Object)this.uuid(), (Object)this.action);
                return this;
            }
            try {
                if (!this.isResumed.getAndSet(true) && this.isInScope.get()) {
                    this.suspended.set(false);
                    logger.trace("AtmosphereResource {} is resuming", (Object)this.uuid());
                    this.action.type(Action.TYPE.RESUME);
                    boolean notify = true;
                    for (Broadcaster b : this.broadcasters) {
                        if (!b.isDestroyed() && b instanceof DefaultBroadcaster) {
                            ((DefaultBroadcaster)b).broadcastOnResume(this);
                        }
                        if (notify) {
                            notify = false;
                            this.notifyListeners();
                        }
                        if (b.getScope() != Broadcaster.SCOPE.REQUEST) continue;
                        logger.debug("Broadcaster's scope is set to request, destroying it {}", (Object)b.getID());
                        b.destroy();
                    }
                    this.removeFromAllBroadcasters();
                    try {
                        this.req.setAttribute("org.atmosphere.cpr.AtmosphereServlet.resumedOnTimeout", Boolean.FALSE);
                    }
                    catch (Exception ex) {
                        logger.debug("Resume exception: Cannot resume an already resumed/cancelled request", (Throwable)ex);
                    }
                    if (this.req.getAttribute(PRE_SUSPEND) == null) {
                        this.asyncSupport.action(this);
                    }
                    break block13;
                }
                logger.trace("Already resumed {}", (Object)this);
                AtmosphereResourceImpl notify = this;
                return notify;
            }
            catch (Throwable t) {
                logger.trace("Wasn't able to resume a connection {}", (Object)this, (Object)t);
            }
            finally {
                this.unregister();
                Utils.destroyMeteor(this.req);
            }
        }
        this.listeners.clear();
        return this;
    }

    @Override
    public AtmosphereResource suspend() {
        return this.suspend(-1L);
    }

    @Override
    public AtmosphereResource suspend(long timeout, TimeUnit timeunit) {
        long timeoutms = -1L;
        if (timeunit != null) {
            timeoutms = TimeUnit.MILLISECONDS.convert(timeout, timeunit);
        }
        return this.suspend(timeoutms);
    }

    @Override
    public AtmosphereResource suspend(long timeout) {
        if (this.event.isSuspended() || this.disableSuspend) {
            return this;
        }
        if (this.config.isSupportSession() && this.req.getSession(false) != null && this.req.getSession().getMaxInactiveInterval() >= 0 && (long)this.req.getSession().getMaxInactiveInterval() * 1000L < timeout) {
            throw new IllegalStateException("Cannot suspend a response longer than the session timeout. Increase the value of session-timeout in web.xml");
        }
        if (Utils.resumableTransport(this.transport())) {
            this.resumeOnBroadcast.set(true);
        }
        this.onPreSuspend(this.event);
        if (this.event.isSuspended() || this.disableSuspend) {
            return this;
        }
        if (!this.event.isResumedOnTimeout()) {
            this.suspended.set(true);
            Enumeration connection = this.req.getHeaders("Connection");
            if (connection == null) {
                connection = this.req.getHeaders("connection");
            }
            if (connection != null && connection.hasMoreElements()) {
                String[] e;
                for (String upgrade : e = ((String)connection.nextElement()).toString().split(",")) {
                    if (!upgrade.trim().equalsIgnoreCase("Upgrade")) continue;
                    if (!this.asyncSupport.supportWebSocket()) {
                        this.response.addHeader("X-Atmosphere-error", "Websocket protocol not supported");
                        continue;
                    }
                    this.req.setAttribute(FrameworkConfig.TRANSPORT_IN_USE, "websocket");
                }
            }
            if (this.req.getHeader("X-Atmosphere-Transport") == null || this.transport().equals((Object)AtmosphereResource.TRANSPORT.UNDEFINED)) {
                this.req.setAttribute(FrameworkConfig.TRANSPORT_IN_USE, "long-polling");
            }
            this.req.setAttribute(PRE_SUSPEND, "true");
            this.action.type(Action.TYPE.SUSPEND);
            this.action.timeout(timeout);
            boolean isJersey = this.req.getAttribute("org.atmosphere.jersey.containerResponse") != null;
            boolean skipCreation = false;
            if (this.req.getAttribute(SKIP_BROADCASTER_CREATION) != null) {
                skipCreation = true;
            }
            Broadcaster broadcaster = this.getBroadcaster();
            if (!(skipCreation || broadcaster != null && broadcaster.getScope() != Broadcaster.SCOPE.REQUEST || isJersey)) {
                String id = broadcaster != null ? broadcaster.getID() : "/*";
                Class clazz = broadcaster != null ? broadcaster.getClass() : DefaultBroadcaster.class;
                broadcaster = this.config.getBroadcasterFactory().lookup(clazz, id, false);
                if (broadcaster == null || !broadcaster.getAtmosphereResources().isEmpty()) {
                    broadcaster = this.config.getBroadcasterFactory().lookup(clazz, id + "/" + UUID.randomUUID(), true);
                }
            }
            broadcaster.addAtmosphereResource(this);
            if (this.req.getAttribute(DefaultBroadcaster.CACHED) != null && this.transport() != null && Utils.resumableTransport(this.transport())) {
                this.action.type(Action.TYPE.CONTINUE);
                logger.debug("Cached message found, not suspending {}", (Object)this.uuid());
                return this;
            }
            this.req.removeAttribute(PRE_SUSPEND);
            this.register();
            this.notifyListeners();
        }
        return this;
    }

    public AtmosphereRequest getRequest(boolean enforceScope) {
        if (enforceScope && !this.isInScope.get()) {
            throw new IllegalStateException("Request object no longer valid. This object has been cancelled");
        }
        return this.req;
    }

    public AtmosphereResponse getResponse(boolean enforceScope) {
        if (enforceScope && !this.isInScope.get()) {
            throw new IllegalStateException("Response object no longer valid. This object has been cancelled");
        }
        return this.response;
    }

    @Override
    public AtmosphereRequest getRequest() {
        return this.getRequest(true);
    }

    @Override
    public AtmosphereResponse getResponse() {
        return this.getResponse(true);
    }

    @Override
    public Broadcaster getBroadcaster() {
        return this.getBroadcaster(true);
    }

    @Override
    public List<Broadcaster> broadcasters() {
        return Collections.unmodifiableList(this.broadcasters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Broadcaster getBroadcaster(boolean autoCreate) {
        if (this.broadcaster == null) {
            throw new IllegalStateException("No Broadcaster associated with this AtmosphereResource.");
        }
        String s = this.config.getInitParameter("org.atmosphere.cpr.recoverFromDestroyedBroadcaster");
        if (s != null) {
            autoCreate = Boolean.parseBoolean(s);
        }
        if (autoCreate && this.broadcaster.isDestroyed() && this.config.getBroadcasterFactory() != null) {
            logger.debug("Broadcaster {} has been destroyed and cannot be re-used. Recreating a new one with the same name. You can turn off this mechanism by adding, in web.xml, {} set to false", (Object)this.broadcaster.getID(), (Object)"org.atmosphere.cpr.recoverFromDestroyedBroadcaster");
            Broadcaster.SCOPE scope = this.broadcaster.getScope();
            AtmosphereResourceImpl atmosphereResourceImpl = this;
            synchronized (atmosphereResourceImpl) {
                String id = scope != Broadcaster.SCOPE.REQUEST ? this.broadcaster.getID() : this.broadcaster.getID() + ".recovered" + this.config.uuidProvider().generateUuid();
                this.broadcaster = this.config.getBroadcasterFactory().lookup(id, true);
                this.broadcaster.setScope(scope);
                this.broadcaster.addAtmosphereResource(this);
            }
        }
        return this.broadcaster;
    }

    @Override
    public AtmosphereResource setBroadcaster(Broadcaster broadcaster) {
        this.broadcaster = broadcaster;
        return this.uniqueBroadcaster(broadcaster);
    }

    @Override
    public AtmosphereResource addBroadcaster(Broadcaster broadcaster) {
        return this.uniqueBroadcaster(broadcaster);
    }

    @Override
    public AtmosphereResource removeBroadcaster(Broadcaster broadcaster) {
        this.broadcasters.remove(broadcaster);
        return this;
    }

    protected AtmosphereResource uniqueBroadcaster(Broadcaster newB) {
        if (newB == null) {
            return this;
        }
        for (Broadcaster b : this.broadcasters) {
            if (b.getID() == null || !b.getID().equalsIgnoreCase(newB.getID())) continue;
            logger.trace("Duplicate Broadcaster {}", (Object)newB);
            return this;
        }
        this.broadcasters.add(newB);
        return this;
    }

    @Override
    public AtmosphereConfig getAtmosphereConfig() {
        return this.config;
    }

    public Action action() {
        return this.action;
    }

    public void reset() {
        this.isResumed.set(false);
        this.isCancelled.set(false);
        this.isPendingClose.set(false);
        this.isInScope.set(true);
        this.isSuspendEvent.set(false);
        this.listeners.clear();
        this.action.type(Action.TYPE.CREATED);
    }

    public void setIsInScope(boolean isInScope) {
        this.isInScope.set(isInScope);
    }

    public boolean isInScope() {
        return this.isInScope.get();
    }

    @Override
    public AtmosphereResource setSerializer(Serializer s) {
        this.serializer = s;
        return this;
    }

    @Override
    public boolean isResumed() {
        return this.isResumed.get();
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled.get();
    }

    @Override
    public AtmosphereResource write(String s) {
        this.response.write(s);
        if (this.resumeOnBroadcast()) {
            this.resume();
        }
        return this;
    }

    @Override
    public AtmosphereResource write(byte[] o) {
        this.response.write(o);
        if (this.resumeOnBroadcast()) {
            this.resume();
        }
        return this;
    }

    @Override
    public Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public AtmosphereResource addEventListener(AtmosphereResourceEventListener e) {
        if (this.listeners.contains(e)) {
            return this;
        }
        this.listeners.add(e);
        return this;
    }

    @Override
    public AtmosphereResource removeEventListener(AtmosphereResourceEventListener e) {
        this.listeners.remove(e);
        return this;
    }

    @Override
    public AtmosphereResource removeEventListeners() {
        this.listeners.clear();
        return this;
    }

    @Override
    public AtmosphereResource notifyListeners() {
        this.notifyListeners(this.event);
        return this;
    }

    @Override
    public AtmosphereResource notifyListeners(AtmosphereResourceEvent event) {
        if (this.listeners.isEmpty() && this.config.framework().atmosphereResourceListeners().isEmpty()) {
            logger.trace("No listener with {}", (Object)this.uuid);
            return this;
        }
        logger.trace("Invoking listener {} for {}", this.listeners, (Object)this.uuid);
        Action oldAction = this.action;
        try {
            if (HeartbeatAtmosphereResourceEvent.class.isAssignableFrom(event.getClass())) {
                this.onHeartbeat(event);
            } else if (event.isClosedByApplication()) {
                this.onClose(event);
            } else if (event.isCancelled() || event.isClosedByClient()) {
                if (!this.disconnected.getAndSet(true)) {
                    this.onDisconnect(event);
                } else {
                    logger.trace("Skipping notification, already disconnected {}", (Object)event.getResource().uuid());
                }
            } else if (event.isResuming() || event.isResumedOnTimeout()) {
                this.onResume(event);
            } else if (!this.isSuspendEvent.getAndSet(true) && event.isSuspended()) {
                this.onSuspend(event);
            } else if (event.throwable() != null) {
                this.onThrowable(event);
            } else {
                this.onBroadcast(event);
            }
            if (oldAction.type() != this.action.type()) {
                this.action().type(Action.TYPE.CREATED);
            }
        }
        catch (Throwable t) {
            ((AtmosphereResourceEventImpl)AtmosphereResourceEventImpl.class.cast(event)).setThrowable(t);
            if (event.isSuspended()) {
                logger.warn("Exception during suspend() operation {}", (Object)t.toString());
                logger.debug("", t);
                this.removeFromAllBroadcasters();
            } else {
                logger.debug("Listener error {}", t);
            }
            try {
                this.onThrowable(event);
            }
            catch (Throwable t2) {
                logger.warn("Listener error {}", t2);
            }
        }
        return this;
    }

    @Override
    public AtmosphereResource removeFromAllBroadcasters() {
        for (Broadcaster b : this.broadcasters) {
            try {
                b.removeAtmosphereResource(this);
            }
            catch (Exception ex) {
                logger.trace("", (Throwable)ex);
            }
        }
        return this;
    }

    public void onThrowable(Throwable t) {
        this.onThrowable(new AtmosphereResourceEventImpl(this, false, false, t));
    }

    void onThrowable(AtmosphereResourceEvent e) {
        for (AtmosphereResourceEventListener r : this.listeners) {
            r.onThrowable(e);
        }
    }

    void onHeartbeat(AtmosphereResourceEvent e) {
        for (AtmosphereResourceEventListener r : this.listeners) {
            r.onHeartbeat(e);
        }
    }

    void onSuspend(AtmosphereResourceEvent e) {
        for (AtmosphereResourceEventListener r : this.listeners) {
            if (this.disableSuspendEvent && !AllowInterceptor.class.isAssignableFrom(r.getClass())) continue;
            r.onSuspend(e);
        }
        if (e.getResource() != null) {
            this.config.framework().notifySuspended(e.getResource().uuid());
        }
    }

    void onPreSuspend(AtmosphereResourceEvent e) {
        for (AtmosphereResourceEventListener r : this.listeners) {
            if (this.disableSuspendEvent && !AllowInterceptor.class.isAssignableFrom(r.getClass())) continue;
            r.onPreSuspend(e);
        }
    }

    void onResume(AtmosphereResourceEvent e) {
        for (AtmosphereResourceEventListener r : this.listeners) {
            r.onResume(e);
        }
    }

    void onDisconnect(AtmosphereResourceEvent e) {
        for (AtmosphereResourceEventListener r : this.listeners) {
            r.onDisconnect(e);
            if (!this.transport.equals((Object)AtmosphereResource.TRANSPORT.WEBSOCKET) || !WebSocketEventListener.class.isAssignableFrom(r.getClass())) continue;
            ((WebSocketEventListener)WebSocketEventListener.class.cast(r)).onDisconnect(new WebSocketEventListener.WebSocketEvent<Integer>(1005, WebSocketEventListener.WebSocketEvent.TYPE.CLOSE, this.webSocket));
        }
        if (e.getResource() != null) {
            this.config.framework().notifyDestroyed(e.getResource().uuid());
        }
    }

    void onBroadcast(AtmosphereResourceEvent e) {
        for (AtmosphereResourceEventListener r : this.listeners) {
            r.onBroadcast(e);
        }
    }

    void onClose(AtmosphereResourceEvent e) {
        for (AtmosphereResourceEventListener r : this.listeners) {
            r.onClose(e);
            if (!this.transport.equals((Object)AtmosphereResource.TRANSPORT.WEBSOCKET) || !WebSocketEventListener.class.isAssignableFrom(r.getClass())) continue;
            ((WebSocketEventListener)WebSocketEventListener.class.cast(r)).onClose(new WebSocketEventListener.WebSocketEvent<Integer>(1005, WebSocketEventListener.WebSocketEvent.TYPE.CLOSE, this.webSocket));
        }
    }

    public ConcurrentLinkedQueue<AtmosphereResourceEventListener> atmosphereResourceEventListener() {
        return this.listeners;
    }

    public AtmosphereResourceImpl atmosphereHandler(AtmosphereHandler atmosphereHandler) {
        this.atmosphereHandler = atmosphereHandler;
        return this;
    }

    public void cancel() throws IOException {
        block13: {
            try {
                if (this.isCancelled.getAndSet(true)) break block13;
                this.suspended.set(false);
                logger.trace("Cancelling {}", (Object)this.uuid);
                if (this.config.getBroadcasterFactory() != null) {
                    this.removeFromAllBroadcasters();
                    if (this.transport.equals((Object)AtmosphereResource.TRANSPORT.WEBSOCKET)) {
                        String parentUUID = (String)this.req.getAttribute("org.atmosphere.cpr.AtmosphereResource.suspended.uuid");
                        AtmosphereResource p = this.config.resourcesFactory().find(parentUUID);
                        if (p != null) {
                            p.removeFromAllBroadcasters();
                        }
                    }
                }
                this.asyncSupport.complete(this);
                try {
                    Object o = this.req.getAttribute(METEOR);
                    if (o != null && Meteor.class.isAssignableFrom(o.getClass())) {
                        ((Meteor)Meteor.class.cast(o)).destroy();
                    }
                }
                catch (Exception ex) {
                    logger.trace("Meteor exception {}", (Throwable)ex);
                }
                SessionTimeoutSupport.restoreTimeout(this.req);
                this.action.type(Action.TYPE.CANCELLED);
                if (this.asyncSupport != null) {
                    this.asyncSupport.action(this);
                }
                if (AtmosphereResponseImpl.class.isAssignableFrom(this.response.getClass())) {
                    if (this.closeOnCancel) {
                        ((AtmosphereResponseImpl)AtmosphereResponseImpl.class.cast(this.response)).close();
                    }
                    ((AtmosphereResponseImpl)AtmosphereResponseImpl.class.cast(this.response)).destroy();
                }
                if (AtmosphereRequestImpl.class.isAssignableFrom(this.req.getClass()) && this.closeOnCancel) {
                    ((AtmosphereRequestImpl)AtmosphereRequestImpl.class.cast(this.req)).destroy();
                }
                this.event.destroy();
            }
            finally {
                this.unregister();
            }
        }
    }

    private void unregister() {
        this.config.resourcesFactory().remove(this.uuid);
    }

    public void _destroy() {
        try {
            if (!this.isCancelled.get()) {
                this.removeFromAllBroadcasters();
            }
            this.broadcasters.clear();
            this.unregister();
            this.removeEventListeners();
        }
        catch (Throwable t) {
            logger.trace("destroyResource", t);
        }
        finally {
            this.unregister();
            this.webSocket = null;
        }
    }

    public String toString() {
        try {
            return "AtmosphereResource{\n\t uuid=" + this.uuid + ",\n\t transport=" + (Object)((Object)this.transport()) + ",\n\t isInScope=" + this.isInScope + ",\n\t isResumed=" + this.isResumed() + ",\n\t isCancelled=" + this.isCancelled() + ",\n\t isSuspended=" + this.isSuspended() + ",\n\t broadcasters=" + this.getBroadcaster().getID() + ",\n\t isClosedByClient=" + (this.event != null ? this.event.isClosedByClient() : false) + ",\n\t isClosedByApplication=" + (this.event != null ? this.event.isClosedByApplication() : false) + ",\n\t action=" + this.action + '}';
        }
        catch (NullPointerException ex) {
            return "AtmosphereResourceImpl{" + this.uuid + "}";
        }
    }

    public AtmosphereResourceImpl disableSuspend(boolean disableSuspend) {
        this.disableSuspend = disableSuspend;
        return this;
    }

    @Override
    public HttpSession session(boolean create) {
        if (this.config.isSupportSession() && this.session == null) {
            this.session = this.req.getSession(create);
        }
        return this.session;
    }

    @Override
    public void close() throws IOException {
        this.event.setCloseByApplication(true);
        this.notifyListeners();
        this.cancel();
        if (this.webSocket != null && this.webSocket.isOpen()) {
            this.webSocket.close();
        }
    }

    public void dirtyClose() {
        try {
            this.event.setCancelled(true);
            this.notifyListeners();
            this.cancel();
            if (this.webSocket != null) {
                this.webSocket.close();
            }
        }
        catch (IOException ex) {
            logger.trace("", (Throwable)ex);
        }
    }

    @Override
    public AtmosphereResource forceBinaryWrite(boolean forceBinaryWrite) {
        this.forceBinaryWrite = forceBinaryWrite;
        return this;
    }

    @Override
    public boolean forceBinaryWrite() {
        return this.forceBinaryWrite;
    }

    @Override
    public HttpSession session() {
        return this.session(true);
    }

    public AtmosphereResourceImpl session(HttpSession session) {
        this.session = session;
        return this;
    }

    public AtmosphereResourceImpl cloneState(AtmosphereResource r) {
        for (AtmosphereResourceEventListener l : ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).atmosphereResourceEventListener()) {
            this.addEventListener(l);
        }
        ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).session(r.session());
        boolean isFirst = true;
        for (Broadcaster b : this.broadcasters) {
            if (isFirst) {
                isFirst = false;
                this.setBroadcaster(b);
                continue;
            }
            this.addBroadcaster(b);
        }
        this.atmosphereHandler(r.getAtmosphereHandler());
        return this;
    }

    public ConcurrentLinkedQueue<AtmosphereResourceEventListener> listeners() {
        return this.listeners;
    }

    public AtmosphereResourceImpl disableSuspendEvent(boolean disableSuspendEvent) {
        this.disableSuspendEvent = disableSuspendEvent;
        return this;
    }

    public boolean disableSuspendEvent() {
        return this.disableSuspendEvent;
    }

    public WebSocket webSocket() {
        return this.webSocket;
    }

    public AtmosphereResourceImpl webSocket(WebSocket webSocket) {
        this.webSocket = webSocket;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtmosphereResourceImpl that = (AtmosphereResourceImpl)o;
        return !(this.uuid != null ? !this.uuid.equals(that.uuid) : that.uuid != null);
    }

    public int hashCode() {
        return this.uuid != null ? this.uuid.hashCode() : 0;
    }

    public boolean getAndSetInClosingPhase() {
        return this.inClosingPhase.getAndSet(true);
    }

    public boolean isPendingClose() {
        return this.isPendingClose.get();
    }

    public boolean getAndSetPendingClose() {
        return this.isPendingClose.getAndSet(true);
    }
}

