/**
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.flow.dom;

/**
 * Constants for common element attribute, property, style names.
 *
 * @author Vaadin Ltd
 * @since 1.0
 */
public class ElementConstants {

    /**
     * The style property for width.
     */
    public static final String STYLE_WIDTH = "width";
    /**
     * The style property for min-width.
     */
    public static final String STYLE_MIN_WIDTH = "min-width";
    /**
     * The style property for max-width.
     */
    public static final String STYLE_MAX_WIDTH = "max-width";
    /**
     * The style property for height.
     */
    public static final String STYLE_HEIGHT = "height";
    /**
     * The style property for min-height.
     */
    public static final String STYLE_MIN_HEIGHT = "min-height";
    /**
     * The style property for max-height.
     */
    public static final String STYLE_MAX_HEIGHT = "max-height";
    /**
     * The style property for color.
     */
    public static final String STYLE_COLOR = "color";
    /**
     * The label property.
     */
    public static final String LABEL_PROPERTY_NAME = "label";
    /**
     * The aria-label property.
     */
    public static final String ARIA_LABEL_PROPERTY_NAME = "aria-label";

    private ElementConstants() {
        // Constants only
    }

}
