/**
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.flow.router;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Defines the route prefix that a Parent layout adds to a route when used in
 * the active view chain.
 *
 * @since 1.0
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Inherited
@Documented
public @interface RoutePrefix {

    /**
     * Sets the route prefix defined for class.
     * <p>
     * This value accepts also parameter template segments which can be defined
     * using following format: <code>:parameterName[?|*][(regex)]</code>.
     * 
     * @return route prefix to add
     */
    String value();

    /**
     * Have the route chain break on defined class and not take into notice any
     * more parent layout route prefixes.
     * 
     * @return route up to here should be absolute
     */
    boolean absolute() default false;
}
