/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.demo;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.NodeVisitor;
import com.vaadin.flow.dom.ShadowRoot;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class WhenDefinedManager
implements Serializable {
    private static final DoneMarker DONE_MARKER = new DoneMarker();
    private final UI ui;
    private final HashMap<String, ArrayList<Command>> tagToWaiters = new HashMap();

    private WhenDefinedManager(UI ui) {
        this.ui = ui;
    }

    public void whenDefined(Component[] rootComponents, Command command) {
        Set<String> vaadinTagNames = WhenDefinedManager.collectVaadinTagNames(rootComponents);
        WhenDefinedManager.collectComponentClasses(rootComponents).forEach(arg_0 -> ((UIInternals)this.ui.getInternals()).addComponentDependencies(arg_0));
        HashSet<String> missingTagNames = new HashSet<String>();
        for (String tagName : vaadinTagNames) {
            ArrayList<Object> tagWaiters = this.tagToWaiters.get(tagName);
            if (tagWaiters instanceof DoneMarker) continue;
            missingTagNames.add(tagName);
            if (tagWaiters == null) {
                tagWaiters = new ArrayList();
                this.tagToWaiters.put(tagName, tagWaiters);
                this.ui.getPage().executeJs("return customElements.whenDefined($0)", new Serializable[]{tagName}).then((SerializableConsumer & Serializable)ignore -> this.handleLoadedTag(tagName));
            }
            tagWaiters.add((Command & Serializable)() -> {
                missingTagNames.remove(tagName);
                if (missingTagNames.isEmpty()) {
                    command.execute();
                }
            });
        }
        if (missingTagNames.isEmpty()) {
            command.execute();
        }
    }

    private static Set<Class<? extends Component>> collectComponentClasses(Component[] rootComponents) {
        HashSet<Class<? extends Component>> classes = new HashSet<Class<? extends Component>>();
        LinkedList<Component> queue = new LinkedList<Component>(Arrays.asList(rootComponents));
        while (!queue.isEmpty()) {
            Component component = queue.removeLast();
            classes.add(component.getClass());
            component.getChildren().forEach(queue::add);
        }
        return classes;
    }

    private void handleLoadedTag(String tagName) {
        ArrayList<Command> waiters = this.tagToWaiters.get(tagName);
        this.tagToWaiters.put(tagName, DONE_MARKER);
        waiters.forEach(Command::execute);
    }

    private static Set<String> collectVaadinTagNames(Component[] rootComponents) {
        final HashSet<String> vaadinTagNames = new HashSet<String>();
        for (Component rootComponent : rootComponents) {
            rootComponent.getElement().accept(new NodeVisitor(){

                public boolean visit(NodeVisitor.ElementType type, Element element) {
                    String tag;
                    if (!element.isTextNode() && (tag = element.getTag()).startsWith("vaadin-")) {
                        vaadinTagNames.add(tag);
                    }
                    return true;
                }

                public boolean visit(ShadowRoot root) {
                    return true;
                }
            });
        }
        return vaadinTagNames;
    }

    public static WhenDefinedManager get(UI ui) {
        WhenDefinedManager instance = (WhenDefinedManager)ComponentUtil.getData((Component)ui, WhenDefinedManager.class);
        if (instance == null) {
            instance = new WhenDefinedManager(ui);
            ComponentUtil.setData((Component)ui, WhenDefinedManager.class, (Object)instance);
        }
        return instance;
    }

    private static class DoneMarker
    extends ArrayList<Command> {
        private DoneMarker() {
        }

        @Override
        public boolean add(Command ignore) {
            throw new UnsupportedOperationException();
        }
    }
}

