/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.data.provider.AbstractComponentDataGenerator;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.ValueProvider;
import elemental.json.JsonObject;

public class ComponentDataGenerator<T>
extends AbstractComponentDataGenerator<T> {
    private final ComponentRenderer<? extends Component, T> componentRenderer;
    private final ValueProvider<T, String> keyMapper;
    private String nodeIdPropertyName;
    private Element container;

    public ComponentDataGenerator(ComponentRenderer<? extends Component, T> componentRenderer, ValueProvider<T, String> keyMapper) {
        this.componentRenderer = componentRenderer;
        this.keyMapper = keyMapper;
    }

    @Override
    public void generateData(T item, JsonObject jsonObject) {
        int nodeId;
        if (this.nodeIdPropertyName == null) {
            return;
        }
        String itemKey = this.getItemKey(item);
        Component oldRenderedComponent = this.getRenderedComponent(itemKey);
        if (oldRenderedComponent != null) {
            nodeId = oldRenderedComponent.getElement().getNode().getId();
        } else {
            Component renderedComponent = this.createComponent(item);
            this.registerRenderedComponent(itemKey, renderedComponent);
            nodeId = renderedComponent.getElement().getNode().getId();
        }
        jsonObject.put(this.nodeIdPropertyName, (double)nodeId);
    }

    @Override
    protected Component createComponent(T item) {
        return this.componentRenderer.createComponent(item);
    }

    @Override
    protected Component updateComponent(Component currentComponent, T item) {
        return this.componentRenderer.updateComponent(currentComponent, item);
    }

    @Override
    protected String getItemKey(T item) {
        if (this.keyMapper == null) {
            return null;
        }
        return (String)this.keyMapper.apply(item);
    }

    @Override
    protected Element getContainer() {
        return this.container;
    }

    public void setContainer(Element container) {
        this.container = container;
    }

    public ComponentRenderer<? extends Component, T> getComponentRenderer() {
        return this.componentRenderer;
    }

    public String getNodeIdPropertyName() {
        return this.nodeIdPropertyName;
    }

    public void setNodeIdPropertyName(String nodeIdPropertyName) {
        this.nodeIdPropertyName = nodeIdPropertyName;
    }
}

