/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.validator;

import com.vaadin.flow.data.validator.RegexpValidator;

public class EmailValidator
extends RegexpValidator {
    private static final String PATTERN = "^([a-zA-Z0-9_\\.\\-+])+@[a-zA-Z0-9-.]+\\.[a-zA-Z0-9-]{2,}$";
    private final boolean allowEmptyValue;

    public EmailValidator(String errorMessage) {
        this(errorMessage, false);
    }

    public EmailValidator(String errorMessage, boolean allowEmpty) {
        super(errorMessage, PATTERN, true);
        this.allowEmptyValue = allowEmpty;
    }

    @Override
    protected boolean isValid(String value) {
        if (this.allowEmptyValue && value != null && value.isEmpty()) {
            return true;
        }
        return super.isValid(value);
    }
}

