/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.data.provider.QuerySortOrder;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalQuery;
import com.vaadin.flow.internal.Range;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HierarchyMapper<T, F>
implements Serializable {
    private Map<T, Set<T>> childMap = new HashMap<T, Set<T>>();
    private Map<Object, T> parentIdMap = new HashMap<Object, T>();
    private final HierarchicalDataProvider<T, F> provider;
    private F filter;
    private List<QuerySortOrder> backEndSorting;
    private Comparator<T> inMemorySorting;
    private Map<Object, T> expandedItems = new HashMap<Object, T>();

    public HierarchyMapper(HierarchicalDataProvider<T, F> provider) {
        this.provider = provider;
    }

    public int getTreeSize() {
        return (int)this.getHierarchy(null).count();
    }

    public int getRootSize() {
        return this.getDataProvider().getChildCount(new HierarchicalQuery<Object, F>(this.filter, null));
    }

    public Integer getParentIndex(T item) {
        List flatHierarchy = this.getHierarchy(null).collect(Collectors.toList());
        return flatHierarchy.indexOf(this.getParentOfItem(item));
    }

    public Integer getIndex(T item) {
        List flatHierarchy = this.getHierarchy(null).collect(Collectors.toList());
        return flatHierarchy.indexOf(item);
    }

    public boolean isExpanded(T item) {
        if (item == null) {
            return true;
        }
        return this.expandedItems.containsKey(this.getDataProvider().getId(item));
    }

    public boolean expand(T item) {
        return this.doExpand(item);
    }

    public Range expand(T item, Integer position) {
        if (this.doExpand(item) && position != null) {
            return Range.withLength((int)(position + 1), (int)((int)this.getHierarchy(item, false).count()));
        }
        return Range.withLength((int)0, (int)0);
    }

    private boolean doExpand(T item) {
        boolean expanded = false;
        if (!this.isExpanded(item) && this.hasChildren(item)) {
            this.expandedItems.put(this.getDataProvider().getId(item), item);
            expanded = true;
        }
        return expanded;
    }

    public boolean collapse(T item) {
        if (item == null) {
            return false;
        }
        if (this.isExpanded(item)) {
            this.expandedItems.remove(this.getDataProvider().getId(item));
            return true;
        }
        return false;
    }

    public Range collapse(T item, Integer position) {
        Range removedRows = Range.withLength((int)0, (int)0);
        if (this.isExpanded(item)) {
            if (position != null) {
                removedRows = Range.withLength((int)(position + 1), (int)((int)this.getHierarchy(item, false).count()));
            }
            this.expandedItems.remove(this.getDataProvider().getId(item));
        }
        return removedRows;
    }

    public Comparator<T> getInMemorySorting() {
        return this.inMemorySorting;
    }

    public void setInMemorySorting(Comparator<T> inMemorySorting) {
        this.inMemorySorting = inMemorySorting;
    }

    public List<QuerySortOrder> getBackEndSorting() {
        return this.backEndSorting;
    }

    public void setBackEndSorting(List<QuerySortOrder> backEndSorting) {
        this.backEndSorting = backEndSorting;
    }

    public F getFilter() {
        return this.filter;
    }

    public void setFilter(Object filter) {
        this.filter = filter;
    }

    public HierarchicalDataProvider<T, F> getDataProvider() {
        return this.provider;
    }

    public boolean hasChildren(T item) {
        return this.getDataProvider().hasChildren(item);
    }

    public Stream<T> fetchHierarchyItems(Range range) {
        return this.getHierarchy(null).skip(range.getStart()).limit(range.length());
    }

    public Stream<T> fetchHierarchyItems(T parent, Range range) {
        return this.getHierarchy(parent, false).skip(range.getStart()).limit(range.length());
    }

    public Stream<T> fetchRootItems(Range range) {
        return this.getDirectChildren(null, range);
    }

    public Stream<T> fetchChildItems(T parent, Range range) {
        return this.getChildrenStream(parent, range, false);
    }

    public int countChildItems(T parent) {
        return this.getDataProvider().getChildCount(new HierarchicalQuery<T, F>(this.filter, parent));
    }

    private Stream<T> doFetchDirectChildren(T parent, Range range) {
        Range actualRange = range == null ? Range.withLength((int)0, (int)Integer.MAX_VALUE) : range;
        return this.getDataProvider().fetchChildren(new HierarchicalQuery<T, F>(actualRange.getStart(), actualRange.length(), this.getBackEndSorting(), this.getInMemorySorting(), this.getFilter(), parent));
    }

    private Stream<T> doFetchDirectChildren(T parent) {
        return this.doFetchDirectChildren(parent, null);
    }

    public int getDepth(T item) {
        int depth = -1;
        while (item != null) {
            item = this.getParentOfItem(item);
            ++depth;
        }
        return depth;
    }

    protected T getParentOfItem(T item) {
        Objects.requireNonNull(item, "Can not find the parent of null");
        return this.parentIdMap.get(this.getDataProvider().getId(item));
    }

    protected void removeChildren(Object id) {
        Iterator<Map.Entry<T, Set<T>>> iterator = this.childMap.entrySet().iterator();
        HashSet invalidatedChildren = new HashSet();
        while (iterator.hasNext()) {
            Map.Entry<T, Set<T>> entry = iterator.next();
            T key = entry.getKey();
            if (key == null || !this.getDataProvider().getId(key).equals(id)) continue;
            invalidatedChildren.addAll(entry.getValue());
            iterator.remove();
        }
        this.expandedItems.remove(id);
        invalidatedChildren.stream().map(this.getDataProvider()::getId).forEach(x -> {
            this.removeChildren(x);
            this.parentIdMap.remove(x);
        });
    }

    public Optional<Integer> getIndexOf(T target) {
        if (target == null) {
            return Optional.empty();
        }
        List collect = this.getHierarchy(null).map(this.provider::getId).collect(Collectors.toList());
        int index = collect.indexOf(this.getDataProvider().getId(target));
        return Optional.ofNullable(index < 0 ? null : Integer.valueOf(index));
    }

    private Stream<T> getHierarchy(T parent) {
        return this.getHierarchy(parent, true);
    }

    private Stream<T> getHierarchy(T parent, boolean includeParent) {
        return Stream.of(parent).flatMap(node -> this.getFlatChildrenStream(node, includeParent));
    }

    private Stream<T> getDirectChildren(T parent, Range range) {
        return this.getChildrenStream(parent, range, false);
    }

    private Stream<T> getFlatChildrenStream(T parent) {
        return this.getFlatChildrenStream(parent, true);
    }

    private Stream<T> getFlatChildrenStream(T parent, boolean includeParent) {
        List childList = Collections.emptyList();
        if (this.isExpanded(parent)) {
            try (Stream stream = this.doFetchDirectChildren(parent);){
                childList = stream.collect(Collectors.toList());
            }
            if (childList.isEmpty()) {
                this.removeChildren(parent == null ? null : this.getDataProvider().getId(parent));
            } else {
                this.registerChildren(parent, childList);
            }
        }
        return this.combineParentAndChildStreams(parent, childList.stream().flatMap(this::getFlatChildrenStream), includeParent);
    }

    private Stream<T> getChildrenStream(T parent, Range range, boolean includeParent) {
        List childList = Collections.emptyList();
        if (this.isExpanded(parent)) {
            try (Stream stream = this.doFetchDirectChildren(parent, range);){
                childList = stream.collect(Collectors.toList());
            }
            if (childList.isEmpty()) {
                this.removeChildren(parent == null ? null : this.getDataProvider().getId(parent));
            } else {
                this.registerChildren(parent, childList);
            }
        }
        return this.combineParentAndChildStreams(parent, childList.stream(), includeParent);
    }

    protected void registerChildren(T parent, List<T> childList) {
        this.childMap.put(parent, new HashSet<T>(childList));
        childList.forEach(x -> this.parentIdMap.put(this.getDataProvider().getId(x), parent));
    }

    private Stream<T> combineParentAndChildStreams(T parent, Stream<T> children, boolean includeParent) {
        boolean parentIncluded = includeParent && parent != null;
        Stream parentStream = parentIncluded ? Stream.of(parent) : Stream.empty();
        return Stream.concat(parentStream, children);
    }

    public void destroyAllData() {
        this.childMap.clear();
        this.parentIdMap.clear();
        this.expandedItems.clear();
    }

    public boolean hasExpandedItems() {
        return !this.expandedItems.isEmpty();
    }

    public Collection<T> getExpandedItems() {
        return Collections.unmodifiableCollection(this.expandedItems.values());
    }
}

