/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.data.provider.AbstractDataProvider;
import com.vaadin.flow.data.provider.BackEndDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.QuerySortOrder;
import com.vaadin.flow.data.provider.SortOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractBackEndDataProvider<T, F>
extends AbstractDataProvider<T, F>
implements BackEndDataProvider<T, F> {
    private List<QuerySortOrder> sortOrders = new ArrayList<QuerySortOrder>();

    private Query<T, F> mixInSortOrders(Query<T, F> query) {
        if (this.sortOrders.isEmpty()) {
            return query;
        }
        Set sortedPropertyNames = query.getSortOrders().stream().map(SortOrder::getSorted).collect(Collectors.toSet());
        List<QuerySortOrder> combinedSortOrders = Stream.concat(query.getSortOrders().stream(), this.sortOrders.stream().filter(order -> !sortedPropertyNames.contains(order.getSorted()))).collect(Collectors.toList());
        return new Query<T, Object>(query.getOffset(), query.getLimit(), combinedSortOrders, query.getInMemorySorting(), query.getFilter().orElse(null));
    }

    @Override
    public Stream<T> fetch(Query<T, F> query) {
        return this.fetchFromBackEnd(this.mixInSortOrders(query));
    }

    @Override
    public int size(Query<T, F> query) {
        return this.sizeInBackEnd(this.mixInSortOrders(query));
    }

    protected abstract Stream<T> fetchFromBackEnd(Query<T, F> var1);

    protected abstract int sizeInBackEnd(Query<T, F> var1);

    @Override
    public void setSortOrders(List<QuerySortOrder> sortOrders) {
        this.sortOrders = Objects.requireNonNull(sortOrders, "Sort orders cannot be null");
        this.refreshAll();
    }
}

