/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValidationResultWrap;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class BindingValidationStatus<TARGET>
implements Serializable {
    private final Status status;
    private final List<ValidationResult> results;
    private final Binder.Binding<?, TARGET> binding;
    private Result<TARGET> result;

    public BindingValidationStatus(Result<TARGET> result, Binder.Binding<?, TARGET> source) {
        Objects.requireNonNull(source, "Event source may not be null");
        this.binding = source;
        if (result != null) {
            Status status = this.status = result.isError() ? Status.ERROR : Status.OK;
            this.results = result instanceof ValidationResultWrap ? ((ValidationResultWrap)result).getValidationResults() : Collections.emptyList();
        } else {
            this.status = Status.UNRESOLVED;
            this.results = Collections.emptyList();
        }
        this.result = result;
    }

    public static <TARGET> BindingValidationStatus<TARGET> createUnresolvedStatus(Binder.Binding<?, TARGET> source) {
        return new BindingValidationStatus<TARGET>(null, source);
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isError() {
        return this.status == Status.ERROR;
    }

    public Optional<String> getMessage() {
        if (this.getStatus() == Status.OK || this.result == null) {
            return Optional.empty();
        }
        return this.result.getMessage();
    }

    public Optional<ValidationResult> getResult() {
        if (this.result == null) {
            return Optional.empty();
        }
        return Optional.of(this.result.isError() ? ValidationResult.error(this.result.getMessage().orElse("")) : ValidationResult.ok());
    }

    public List<ValidationResult> getValidationResults() {
        return Collections.unmodifiableList(this.results);
    }

    public Binder.Binding<?, TARGET> getBinding() {
        return this.binding;
    }

    public HasValue<?, ?> getField() {
        return this.getBinding().getField();
    }

    public static enum Status {
        OK,
        ERROR,
        UNRESOLVED;

    }
}

