/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.dnd;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dnd.DropEffect;
import com.vaadin.flow.component.dnd.EffectAllowed;
import java.util.Optional;

@DomEvent(value="drop")
public class DropEvent<T extends Component>
extends ComponentEvent<T> {
    private final EffectAllowed effectAllowed;
    private final String dropEffect;
    private final Component dragSourceComponent;

    public DropEvent(T source, boolean fromClient, @EventData(value="event.dataTransfer.effectAllowed") String effectAllowed) {
        super(source, fromClient);
        this.effectAllowed = EffectAllowed.fromString(effectAllowed);
        this.dropEffect = source.getElement().getProperty("__dropEffect");
        this.dragSourceComponent = ((UI)this.getComponent().getUI().orElseThrow(() -> new IllegalStateException("Drop target received a drop event but not attached to an UI."))).getActiveDragSourceComponent();
    }

    public Optional<Object> getDragData() {
        return this.getDragSourceComponent().map(component -> ComponentUtil.getData((Component)component, (String)"drag-source-data"));
    }

    public DropEffect getDropEffect() {
        return this.dropEffect == null ? null : DropEffect.fromString(this.dropEffect);
    }

    public EffectAllowed getEffectAllowed() {
        return this.effectAllowed;
    }

    public Optional<Component> getDragSourceComponent() {
        return Optional.ofNullable(this.dragSourceComponent);
    }

    public T getComponent() {
        return (T)this.getSource();
    }
}

