/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.dnd.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.dnd.DragSource;
import com.vaadin.flow.component.dnd.DropTarget;
import com.vaadin.flow.dom.ElementDetachListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;

public class DndUtil {
    public static final String DND_CONNECTOR = "./dndConnector-es6.js";
    public static final String EFFECT_ALLOWED_ELEMENT_PROPERTY = "__effectAllowed";
    public static final String DRAG_SOURCE_DATA_KEY = "drag-source-data";
    public static final String START_LISTENER_REGISTRATION_KEY = "_startListenerRegistration";
    public static final String END_LISTENER_REGISTRATION_KEY = "_endListenerRegistration";
    public static final String DROP_TARGET_ACTIVE_PROPERTY = "__active";
    public static final String DROP_EFFECT_ELEMENT_PROPERTY = "__dropEffect";
    private static final String DETACH_LISTENER_FOR_DROP_TARGET = "_detachListenerForDropTarget";
    static final String MOBILE_POLYFILL_INJECT_SCRIPT = "if ((/iPad|iPhone|iPod/.test(navigator.userAgent) && !window.MSStream)|| (navigator.platform === 'MacIntel' && navigator.maxTouchPoints > 1)) {var script1 = document.createElement('script');var script2 = document.createElement('script');script1.async = false;script2.async = false;script1.src = \"%1$s\";script2.src = \"%2$s\";window.Vaadin.__forceApplyMobileDragDrop = true;document.head.appendChild(script1);document.head.appendChild(script2);}";
    private static final String DND_POLYFILL_SCRIPT_KEY = "DND-POLYFILL-SCRIPT";
    private static final String MOBILE_DND_POLYFILL_URL = "context://webjars/mobile-drag-drop/2.3.0-rc.2/index.min.js";
    private static final String VAADIN_MOBILE_DND_POLYFILL_URL = "context://webjars/vaadin__vaadin-mobile-drag-drop/1.0.1/index.min.js";

    private DndUtil() {
    }

    public static void addMobileDndPolyfillIfNeeded(Component component) {
        component.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> {
            if (ComponentUtil.getData((Component)ui, (String)DND_POLYFILL_SCRIPT_KEY) != null) {
                return;
            }
            String url1 = ui.getSession().getService().resolveResource(MOBILE_DND_POLYFILL_URL);
            String url2 = ui.getSession().getService().resolveResource(VAADIN_MOBILE_DND_POLYFILL_URL);
            ui.getPage().executeJs(String.format(MOBILE_POLYFILL_INJECT_SCRIPT, url1, url2), new Serializable[0]);
            ComponentUtil.setData((Component)ui, (String)DND_POLYFILL_SCRIPT_KEY, (Object)true);
        });
    }

    public static <T extends Component> void updateDragSourceActivation(DragSource<T> dragSource) {
        Command & Serializable command = (Command & Serializable)() -> dragSource.getDraggableElement().executeJs("window.Vaadin.Flow.dndConnector.updateDragSource($0)", new Serializable[]{dragSource.getDraggableElement()});
        DndUtil.runOnAttachBeforeResponse(dragSource.getDragSourceComponent(), command);
    }

    public static <T extends Component> void updateDropTargetActivation(DropTarget<T> dropTarget) {
        Command & Serializable command = (Command & Serializable)() -> dropTarget.getElement().executeJs("window.Vaadin.Flow.dndConnector.updateDropTarget($0)", new Serializable[]{dropTarget.getElement()});
        DndUtil.runOnAttachBeforeResponse(dropTarget.getDropTargetComponent(), command);
        if (ComponentUtil.getData(dropTarget.getDropTargetComponent(), (String)DETACH_LISTENER_FOR_DROP_TARGET) == null) {
            Registration detachRegistration = dropTarget.getElement().addDetachListener((ElementDetachListener & Serializable)event -> DndUtil.runOnAttachBeforeResponse(dropTarget.getDropTargetComponent(), command));
            ComponentUtil.setData(dropTarget.getDropTargetComponent(), (String)DETACH_LISTENER_FOR_DROP_TARGET, (Object)detachRegistration);
        }
    }

    private static void runOnAttachBeforeResponse(Component component, Command command) {
        component.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse(component, (SerializableConsumer & Serializable)context -> command.execute()));
    }

    public static void reportUsage() {
        UsageStatistics.markAsUsed((String)"flow/generic-dnd", null);
    }
}

