/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.gradle;

import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendToolsSettings;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.gradle.VaadinFlowPluginExtension;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010 \n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\b\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\fH\u0007J\n\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0007J\b\u0010\u000f\u001a\u00020\fH\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0007J\b\u0010\u0012\u001a\u00020\fH\u0007J\n\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0007J\b\u0010\u0014\u001a\u00020\fH\u0007J\b\u0010\u0015\u001a\u00020\fH\u0007J\b\u0010\u0016\u001a\u00020\u0011H\u0007J\b\u0010\u0017\u001a\u00020\u0011H\u0007J\b\u0010\u0018\u001a\u00020\u0011H\u0007J\b\u0010\u0019\u001a\u00020\fH\u0007J\b\u0010\u001a\u001a\u00020\u0011H\u0007J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0011H\u0007J\b\u0010\u001c\u001a\u00020\u0011H\u0007J\n\u0010\u001d\u001a\u0004\u0018\u00010\u0011H\u0007J\b\u0010\u001e\u001a\u00020\u0011H\u0007J\n\u0010\u001f\u001a\u0004\u0018\u00010\nH\u0007J\b\u0010 \u001a\u00020\fH\u0007J\b\u0010!\u001a\u00020\fH\u0007J\n\u0010\"\u001a\u0004\u0018\u00010\u0011H\u0007J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110$H\u0007J\b\u0010%\u001a\u00020\fH\u0007J\b\u0010&\u001a\u00020\u0011H\u0007J\b\u0010'\u001a\u00020\fH\u0007J\b\u0010(\u001a\u00020\fH\u0007J\b\u0010)\u001a\u00020\fH\u0007J\b\u0010*\u001a\u00020\fH\u0007J\n\u0010+\u001a\u0004\u0018\u00010\u0011H\u0007J\b\u0010,\u001a\u00020\bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/vaadin/gradle/PrepareFrontendInputProperties;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "extension", "Lcom/vaadin/gradle/VaadinFlowPluginExtension;", "tools", "Lcom/vaadin/flow/server/frontend/FrontendTools;", "getApplicationProperties", "Ljava/io/File;", "getCiBuild", "", "getEagerServerLoad", "getFeatureFlagsFile", "getForceProductionBuild", "getFrontendDirectory", "", "getFrontendHotdeploy", "getFrontendResourcesDirectory", "getGenerateBundle", "getGenerateEmbeddableWebComponent", "getGeneratedTsFolder", "getJavaResourceFolder", "getJavaSourceFolder", "getNodeAutoUpdate", "getNodeDownloadRoot", "getNodeExecutablePath", "getNodeVersion", "getNpmExecutablePath", "getNpmFolder", "getOpenApiJsonFile", "getOptimizeBundle", "getPnpmEnable", "getPnpmExecutablePath", "getPostInstallPackages", "", "getProductionMode", "getProjectBuildDir", "getRequireHomeNodeExec", "getRunNpmInstall", "getSkipDevBundleBuild", "getUseGlobalPnpm", "getWebpackOutputDirectory", "initialiseFrontendToolsSettings", "flow-gradle-plugin"})
public final class PrepareFrontendInputProperties {
    @NotNull
    private VaadinFlowPluginExtension extension;
    @NotNull
    private final FrontendTools tools;

    public PrepareFrontendInputProperties(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.extension = VaadinFlowPluginExtension.Companion.get(project);
        this.tools = this.initialiseFrontendToolsSettings();
    }

    @Input
    public final boolean getProductionMode() {
        return this.extension.getProductionMode();
    }

    @Input
    @Optional
    @Nullable
    public final String getWebpackOutputDirectory() {
        File webpackOutputDirectory = this.extension.getWebpackOutputDirectory();
        if (webpackOutputDirectory != null && !webpackOutputDirectory.exists()) {
            return null;
        }
        if (webpackOutputDirectory == null) {
            return null;
        }
        return webpackOutputDirectory.getAbsolutePath();
    }

    @Input
    @NotNull
    public final String getNpmFolder() {
        String string = this.extension.getNpmFolder().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    @Input
    @NotNull
    public final String getFrontendDirectory() {
        String string = this.extension.getFrontendDirectory().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    @Input
    public final boolean getGenerateBundle() {
        return this.extension.getGenerateBundle();
    }

    @Input
    public final boolean getRunNpmInstall() {
        return this.extension.getRunNpmInstall();
    }

    @Input
    public final boolean getGenerateEmbeddableWebComponent() {
        return this.extension.getGenerateEmbeddableWebComponents();
    }

    @InputDirectory
    @Optional
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @Nullable
    public final File getFrontendResourcesDirectory() {
        File frontendResourcesDirectory = this.extension.getFrontendResourcesDirectory();
        if (!frontendResourcesDirectory.exists()) {
            return null;
        }
        return frontendResourcesDirectory;
    }

    @Input
    public final boolean getOptimizeBundle() {
        return this.extension.getOptimizeBundle();
    }

    @Input
    public final boolean getPnpmEnable() {
        return this.extension.getPnpmEnable();
    }

    @Input
    public final boolean getUseGlobalPnpm() {
        return this.extension.getUseGlobalPnpm();
    }

    @Input
    public final boolean getRequireHomeNodeExec() {
        return this.extension.getRequireHomeNodeExec();
    }

    @Input
    public final boolean getEagerServerLoad() {
        return this.extension.getEagerServerLoad();
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    @Nullable
    public final File getApplicationProperties() {
        File applicationProperties = this.extension.getApplicationProperties();
        if (!applicationProperties.exists()) {
            return null;
        }
        return applicationProperties;
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @Nullable
    public final File getOpenApiJsonFile() {
        File openApiJsonFile = this.extension.getOpenApiJsonFile();
        if (!openApiJsonFile.exists()) {
            return null;
        }
        return openApiJsonFile;
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @Nullable
    public final File getFeatureFlagsFile() {
        File featureFlagsFile = FilesKt.resolve((File)this.extension.getJavaResourceFolder(), (String)"vaadin-featureflags.properties");
        if (!featureFlagsFile.exists()) {
            return null;
        }
        return featureFlagsFile;
    }

    @Input
    @NotNull
    public final String getJavaSourceFolder() {
        String string = this.extension.getJavaSourceFolder().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    @Input
    @NotNull
    public final String getJavaResourceFolder() {
        String string = this.extension.getJavaResourceFolder().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    @Input
    @NotNull
    public final String getGeneratedTsFolder() {
        String string = this.extension.getGeneratedTsFolder().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    @Input
    @NotNull
    public final String getNodeVersion() {
        return this.extension.getNodeVersion();
    }

    @Input
    @NotNull
    public final String getNodeDownloadRoot() {
        return this.extension.getNodeDownloadRoot();
    }

    @Input
    public final boolean getNodeAutoUpdate() {
        return this.extension.getNodeAutoUpdate();
    }

    @Input
    @NotNull
    public final String getProjectBuildDir() {
        return this.extension.getProjectBuildDir();
    }

    @Input
    @NotNull
    public final List<String> getPostInstallPackages() {
        return this.extension.getPostinstallPackages();
    }

    @Input
    public final boolean getFrontendHotdeploy() {
        return this.extension.getFrontendHotdeploy();
    }

    @Input
    public final boolean getCiBuild() {
        return this.extension.getCiBuild();
    }

    @Input
    public final boolean getSkipDevBundleBuild() {
        return this.extension.getSkipDevBundleBuild();
    }

    @Input
    public final boolean getForceProductionBuild() {
        return this.extension.getForceProductionBuild();
    }

    @Input
    @Optional
    @Nullable
    public final String getNodeExecutablePath() {
        String string = this.tools.getNodeBinary();
        if (string == null) {
            return null;
        }
        String nodeBinary = string;
        File nodeBinaryFile = new File(nodeBinary);
        if (!nodeBinaryFile.exists()) {
            return null;
        }
        return nodeBinaryFile.getAbsolutePath();
    }

    @Input
    @Optional
    @Nullable
    public final String getNpmExecutablePath() {
        List list = this.tools.getNpmExecutable();
        if (list == null) {
            return null;
        }
        List npmExecutable = list;
        return npmExecutable.stream().collect(Collectors.joining(" "));
    }

    @Input
    @Optional
    @Nullable
    public final String getPnpmExecutablePath() {
        if (!this.extension.getPnpmEnable()) {
            return null;
        }
        List list = this.tools.getPnpmExecutable();
        if (list == null) {
            return null;
        }
        List pnpmExecutable = list;
        return pnpmExecutable.stream().collect(Collectors.joining(" "));
    }

    private final FrontendTools initialiseFrontendToolsSettings() {
        FrontendToolsSettings settings = new FrontendToolsSettings(this.extension.getNpmFolder().getAbsolutePath(), PrepareFrontendInputProperties::initialiseFrontendToolsSettings$lambda$0);
        settings.setNodeDownloadRoot(new URI(this.extension.getNodeDownloadRoot()));
        settings.setForceAlternativeNode(this.extension.getRequireHomeNodeExec());
        settings.setUseGlobalPnpm(this.extension.getUseGlobalPnpm());
        settings.setAutoUpdate(this.extension.getNodeAutoUpdate());
        return new FrontendTools(settings);
    }

    private static final String initialiseFrontendToolsSettings$lambda$0() {
        return FrontendUtils.getVaadinHomeDirectory().getAbsolutePath();
    }
}

