/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.gradle;

import com.vaadin.flow.plugin.base.BuildFrontendUtil;
import com.vaadin.flow.plugin.base.PluginAdapterBase;
import com.vaadin.gradle.GradlePluginAdapter;
import com.vaadin.gradle.PluginEffectiveConfiguration;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\bH\u0007J\b\u0010\n\u001a\u00020\bH\u0007J\b\u0010\u000b\u001a\u00020\bH\u0007J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0007J\b\u0010\u000e\u001a\u00020\bH\u0007J\b\u0010\u000f\u001a\u00020\bH\u0007J\b\u0010\u0010\u001a\u00020\bH\u0007J\b\u0010\u0011\u001a\u00020\bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/vaadin/gradle/PrepareFrontendOutputProperties;", "", "project", "Lorg/gradle/api/Project;", "config", "Lcom/vaadin/gradle/PluginEffectiveConfiguration;", "(Lorg/gradle/api/Project;Lcom/vaadin/gradle/PluginEffectiveConfiguration;)V", "getGeneratedTsFolder", "Ljava/io/File;", "getPackageJson", "getPackageLockJson", "getPackageLockYaml", "getResourceOutputDirectory", "Lorg/gradle/api/provider/Property;", "getTsConfig", "getTsDefinition", "getViteConfig", "getViteGeneratedConfig", "flow-gradle-plugin"})
public final class PrepareFrontendOutputProperties {
    @NotNull
    private final Project project;
    @NotNull
    private final PluginEffectiveConfiguration config;

    public PrepareFrontendOutputProperties(@NotNull Project project, @NotNull PluginEffectiveConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.project = project;
        this.config = config;
    }

    @OutputFile
    @NotNull
    public final File getPackageJson() {
        return new File(this.project.getProjectDir(), "package.json");
    }

    @OutputFile
    @NotNull
    public final File getPackageLockJson() {
        return new File(this.project.getProjectDir(), "package-lock.json");
    }

    @OutputFile
    @NotNull
    public final File getPackageLockYaml() {
        return new File(this.project.getProjectDir(), "pnpm-lock.yaml");
    }

    @OutputFile
    @NotNull
    public final File getViteConfig() {
        return new File(this.project.getProjectDir(), "vite.config.ts");
    }

    @OutputFile
    @NotNull
    public final File getViteGeneratedConfig() {
        return new File(this.project.getProjectDir(), "vite.generated.ts");
    }

    @OutputFile
    @NotNull
    public final File getTsConfig() {
        return new File(this.project.getProjectDir(), "tsconfig.json");
    }

    @OutputFile
    @NotNull
    public final File getTsDefinition() {
        return new File(this.project.getProjectDir(), "types.d.ts");
    }

    @OutputDirectory
    @NotNull
    public final File getGeneratedTsFolder() {
        File file = BuildFrontendUtil.getGeneratedFrontendDirectory((PluginAdapterBase)((PluginAdapterBase)new GradlePluginAdapter(this.project, this.config, true)));
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getGeneratedFrontendDirectory(...)");
        return file;
    }

    @OutputDirectory
    @NotNull
    public final Property<File> getResourceOutputDirectory() {
        return this.config.getResourceOutputDirectory();
    }
}

