/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.html;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HtmlContainer;
import com.vaadin.flow.component.PropertyDescriptor;
import com.vaadin.flow.component.PropertyDescriptors;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.html.AnchorTarget;
import com.vaadin.flow.component.html.AnchorTargetValue;
import com.vaadin.flow.server.AbstractStreamResource;
import java.util.Objects;
import java.util.Optional;

@Tag(value="a")
public class Anchor
extends HtmlContainer
implements Focusable<Anchor> {
    private static final PropertyDescriptor<String, String> hrefDescriptor = PropertyDescriptors.attributeWithDefault((String)"href", (String)"", (boolean)false);
    private static final PropertyDescriptor<String, Optional<String>> targetDescriptor = PropertyDescriptors.optionalAttributeWithDefault((String)"target", (String)AnchorTarget.DEFAULT.getValue());
    private static final String ROUTER_IGNORE_ATTRIBUTE = "router-ignore";

    public Anchor() {
    }

    public Anchor(String href, String text) {
        this.setHref(href);
        this.setText(text);
    }

    public Anchor(String href, String text, AnchorTarget target) {
        this.setHref(href);
        this.setText(text);
        this.setTarget(target);
    }

    public Anchor(AbstractStreamResource href, String text) {
        this.setHref(href);
        this.setText(text);
    }

    public Anchor(String href, Component ... components) {
        this.setHref(href);
        this.add(components);
    }

    public void setHref(String href) {
        this.set(hrefDescriptor, href);
    }

    public void removeHref() {
        this.getElement().removeAttribute("href");
    }

    public void setHref(AbstractStreamResource href) {
        this.getElement().setAttribute("href", href);
        this.getElement().setAttribute(ROUTER_IGNORE_ATTRIBUTE, true);
    }

    public String getHref() {
        return (String)this.get(hrefDescriptor);
    }

    public void setTarget(String target) {
        this.set(targetDescriptor, target);
    }

    public Optional<String> getTarget() {
        return (Optional)this.get(targetDescriptor);
    }

    public void setTarget(AnchorTargetValue target) {
        Objects.requireNonNull(target, "target cannot be null.");
        this.setTarget(target.getValue());
    }

    public AnchorTargetValue getTargetValue() {
        Optional<String> target = this.getTarget();
        if (target.isPresent()) {
            return AnchorTargetValue.forString(target.get());
        }
        return AnchorTarget.DEFAULT;
    }
}

