/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.littemplate.internal;

import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.littemplate.BundleLitParser;
import com.vaadin.flow.component.littemplate.LitTemplate;
import com.vaadin.flow.component.littemplate.LitTemplateParser;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.Pair;
import com.vaadin.flow.server.DependencyFilter;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.WebBrowser;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.startup.FakeBrowser;
import com.vaadin.flow.shared.ui.Dependency;
import com.vaadin.flow.shared.ui.LoadMode;
import elemental.json.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.jsoup.UncheckedIOException;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LitTemplateParserImpl
implements LitTemplateParser {
    private static final LitTemplateParser INSTANCE = new LitTemplateParserImpl();
    private final HashMap<String, String> cache = new HashMap();
    private final ReentrantLock templateSourceslock = new ReentrantLock();
    private JsonObject jsonStats;

    protected LitTemplateParserImpl() {
    }

    public static LitTemplateParser getInstance() {
        return INSTANCE;
    }

    @Override
    public LitTemplateParser.TemplateData getTemplateContent(Class<? extends LitTemplate> clazz, String tag, VaadinService service) {
        List dependencies = AnnotationReader.getAnnotationsFor(clazz, JsModule.class).stream().map(jsModule -> new Dependency(Dependency.Type.JS_MODULE, jsModule.value(), LoadMode.EAGER)).collect(Collectors.toList());
        FakeBrowser browser = FakeBrowser.getEs6();
        DependencyFilter.FilterContext filterContext = new DependencyFilter.FilterContext(service, (WebBrowser)browser);
        for (Object filter : service.getDependencyFilters()) {
            dependencies = filter.filter(new ArrayList(dependencies), filterContext);
        }
        Pair chosenDep = null;
        for (Dependency dependency : dependencies) {
            if (dependency.getType() != Dependency.Type.JS_MODULE) continue;
            String url = dependency.getUrl();
            String source = this.getSourcesFromTemplate(tag, url);
            if (source == null) {
                try {
                    source = this.getSourcesFromStats(service, url);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            if (source == null) continue;
            if (chosenDep == null) {
                chosenDep = new Pair((Serializable)dependency, (Serializable)((Object)source));
            }
            if (!this.dependencyHasTagName(dependency, tag)) continue;
            chosenDep = new Pair((Serializable)dependency, (Serializable)((Object)source));
            break;
        }
        Element templateElement = null;
        if (chosenDep != null) {
            templateElement = BundleLitParser.parseLitTemplateElement(((Dependency)chosenDep.getFirst()).getUrl(), (String)((Object)chosenDep.getSecond()));
        }
        if (templateElement != null) {
            Element parent = new Element(tag);
            parent.attr("id", tag);
            templateElement.appendTo(parent);
            return new LitTemplateParser.TemplateData(((Dependency)chosenDep.getFirst()).getUrl(), templateElement);
        }
        this.getLogger().info("Couldn't find the definition of the element with tag '{}' in any lit template file declared using '@{}' annotations. Check the availability of the template files in your WAR file or provide alternative implementation of the method LitTemplateParser.getTemplateContent() which should return an element representing the content of the template file", (Object)tag, (Object)JsModule.class.getSimpleName());
        return null;
    }

    private boolean dependencyHasTagName(Dependency dependency, String tag) {
        String url = FilenameUtils.removeExtension((String)dependency.getUrl()).toLowerCase(Locale.ENGLISH);
        return url.endsWith("/" + tag);
    }

    protected String getSourcesFromTemplate(String tag, String url) {
        InputStream content = this.getClass().getClassLoader().getResourceAsStream(url);
        if (content != null) {
            this.getLogger().debug("Found sources from the tag '{}' in the template '{}'", (Object)tag, (Object)url);
            return FrontendUtils.streamToString((InputStream)content);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSourcesFromStats(VaadinService service, String url) throws IOException {
        this.templateSourceslock.lock();
        try {
            String content;
            if (this.isStatsFileReadNeeded(service) && (content = FrontendUtils.getStatsContent((VaadinService)service)) != null) {
                this.resetCache(content);
            }
            if (!this.cache.containsKey(url) && this.jsonStats != null) {
                this.cache.put(url, BundleLitParser.getSourceFromStatistics(url, this.jsonStats));
            }
            String string = this.cache.get(url);
            return string;
        }
        finally {
            this.templateSourceslock.unlock();
        }
    }

    private boolean isStatsFileReadNeeded(VaadinService service) throws IOException {
        assert (this.templateSourceslock.isHeldByCurrentThread());
        DeploymentConfiguration config = service.getDeploymentConfiguration();
        if (this.jsonStats == null) {
            return true;
        }
        if (this.usesBundleFile(config)) {
            return false;
        }
        return !this.jsonStats.get("hash").asString().equals(FrontendUtils.getStatsHash((VaadinService)service));
    }

    private boolean usesBundleFile(DeploymentConfiguration config) {
        return config.isProductionMode() && !config.enableDevServer();
    }

    private void resetCache(String fileContents) {
        assert (this.templateSourceslock.isHeldByCurrentThread());
        this.cache.clear();
        this.jsonStats = BundleLitParser.parseJsonStatistics(fileContents);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger((String)LitTemplateParserImpl.class.getName());
    }
}

