/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.common;

import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.scanner.ReflectionsClassFinder;
import com.vaadin.flow.utils.FlowFileUtils;
import java.io.File;
import java.net.URL;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;

public class FlowPluginFrontendUtils {
    private FlowPluginFrontendUtils() {
    }

    public static ClassFinder getClassFinder(MavenProject project) {
        List runtimeClasspathElements;
        try {
            runtimeClasspathElements = project.getRuntimeClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IllegalStateException(String.format("Failed to retrieve runtime classpath elements from project '%s'", project), e);
        }
        URL[] urls = (URL[])runtimeClasspathElements.stream().map(File::new).map(FlowFileUtils::convertToUrl).toArray(URL[]::new);
        return new ReflectionsClassFinder(urls);
    }
}

