/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.maven;

import com.vaadin.flow.plugin.common.FlowPluginFrontendUtils;
import com.vaadin.flow.plugin.maven.FlowModeAbstractMojo;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.CvdlProducts;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.NodeTasks;
import com.vaadin.flow.server.frontend.installer.Platform;
import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.Product;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="build-frontend", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class BuildFrontendMojo
extends FlowModeAbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.basedir}")
    private File npmFolder;
    @Parameter(defaultValue="${project.build.directory}/frontend/")
    private File generatedFolder;
    @Parameter(defaultValue="true")
    private boolean generateBundle;
    @Parameter(defaultValue="true")
    private boolean runNpmInstall;
    @Parameter(defaultValue="true")
    private boolean generateEmbeddableWebComponents;
    @Parameter(defaultValue="${project.basedir}/src/main/resources/META-INF/resources/frontend")
    protected File frontendResourcesDirectory;
    @Parameter(defaultValue="true")
    private boolean optimizeBundle;
    @Parameter(defaultValue="false")
    public boolean oldLicenseChecker;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (this.compatibility) {
            this.getLog().info((CharSequence)"Skipped 'build-frontend' goal because compatibility mode is set to true.");
            return;
        }
        this.updateBuildFile();
        long start = System.nanoTime();
        try {
            this.runNodeUpdater();
        }
        catch (ExecutionFailedException exception) {
            throw new MojoFailureException("Could not execute build-frontend goal", (Throwable)exception);
        }
        if (this.generateBundle) {
            try {
                this.runWebpack(this.getFrontendTools());
            }
            catch (IllegalStateException exception) {
                throw new MojoExecutionException(exception.getMessage(), (Exception)exception);
            }
        }
        long ms = (System.nanoTime() - start) / 1000000L;
        this.getLog().info((CharSequence)("update-frontend took " + ms + "ms."));
    }

    private void runNodeUpdater() throws ExecutionFailedException, MojoExecutionException {
        URI nodeDownloadRootURI;
        Set<File> jarFiles = this.getJarFiles();
        if (this.nodeDownloadRoot == null) {
            this.nodeDownloadRoot = Platform.guess().getNodeDownloadRoot();
        }
        try {
            nodeDownloadRootURI = new URI(this.nodeDownloadRoot);
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException("Failed to parse " + this.nodeDownloadRoot, (Exception)e);
        }
        new NodeTasks.Builder(FlowPluginFrontendUtils.getClassFinder(this.project), this.npmFolder, this.generatedFolder, this.frontendDirectory).runNpmInstall(this.runNpmInstall).enablePackagesUpdate(true).useByteCodeScanner(this.optimizeBundle).copyResources(jarFiles).copyLocalResources(this.frontendResourcesDirectory).enableImportsUpdate(true).withEmbeddableWebComponents(this.generateEmbeddableWebComponents).withTokenFile(this.getTokenFile()).enablePnpm(this.pnpmEnable).withHomeNodeExecRequired(this.requireHomeNodeExec).withNodeVersion(this.nodeVersion).withNodeDownloadRoot(nodeDownloadRootURI).withProductionMode(this.productionMode).withCiBuild(this.ciBuild).build().execute();
    }

    void runWebpack(FrontendTools tools) throws MojoExecutionException {
        if (!this.oldLicenseChecker && !this.compatibility) {
            LicenseChecker.setStrictOffline((boolean)true);
        }
        String webpackCommand = "webpack/bin/webpack.js";
        File webpackExecutable = new File(this.npmFolder, "node_modules/" + webpackCommand);
        if (!webpackExecutable.isFile()) {
            throw new IllegalStateException(String.format("Unable to locate webpack executable by path '%s'. Double check that the plugin is executed correctly", webpackExecutable.getAbsolutePath()));
        }
        String nodePath = this.requireHomeNodeExec ? tools.forceAlternativeNodeExecutable() : tools.getNodeExecutable();
        List<String> command = Arrays.asList(nodePath, webpackExecutable.getAbsolutePath());
        ProcessBuilder builder = FrontendUtils.createProcessBuilder(command).directory(this.project.getBasedir()).inheritIO();
        builder.environment().putAll(tools.getWebpackNodeEnvironment());
        this.getLog().info((CharSequence)"Running webpack ...");
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)FrontendUtils.commandToString((String)this.npmFolder.getAbsolutePath(), command));
        }
        Process webpackLaunch = null;
        try {
            webpackLaunch = builder.start();
            int errorCode = webpackLaunch.waitFor();
            if (errorCode != 0) {
                this.readDetailsAndThrowException(webpackLaunch);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException("Failed to run webpack due to an error", e);
        }
        finally {
            if (webpackLaunch != null) {
                webpackLaunch.destroyForcibly();
            }
        }
        this.validateLicenses();
    }

    void validateLicenses() {
        if (this.compatibility || this.oldLicenseChecker) {
            return;
        }
        File nodeModulesFolder = new File(this.npmFolder, "node_modules/");
        File outputFolder = this.webpackOutputDirectory;
        File statsFile = new File(this.webpackOutputDirectory, "config//stats.json");
        if (!statsFile.exists()) {
            throw new RuntimeException("Stats file " + statsFile + " does not exist");
        }
        List<Product> commercialComponents = BuildFrontendMojo.findCommercialFrontendComponents(nodeModulesFolder, statsFile);
        commercialComponents.addAll(this.findCommercialJavaComponents());
        for (Product component : commercialComponents) {
            try {
                LicenseChecker.checkLicense((String)component.getName(), (String)component.getVersion(), (BuildType)BuildType.PRODUCTION);
            }
            catch (Exception e) {
                try {
                    BuildFrontendMojo.getLogger().debug("License check for {} failed. Invalidating output", (Object)component);
                    FileUtils.deleteDirectory((File)outputFolder);
                }
                catch (IOException e1) {
                    BuildFrontendMojo.getLogger().debug("Failed to remove {}", (Object)outputFolder);
                }
                throw e;
            }
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(BuildFrontendMojo.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Product> findCommercialFrontendComponents(File nodeModulesFolder, File statsFile) {
        ArrayList<Product> components = new ArrayList<Product>();
        try (FileInputStream in = new FileInputStream(statsFile);){
            String contents = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            JsonArray npmModules = Json.parse((String)contents).getArray("npmModules");
            for (int i = 0; i < npmModules.length(); ++i) {
                String npmModule = npmModules.getString(i);
                Product product = CvdlProducts.getProductIfCvdl((File)nodeModulesFolder, (String)npmModule);
                if (product == null) continue;
                components.add(product);
            }
            ArrayList<Product> arrayList = components;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading file " + statsFile, e);
        }
    }

    private List<Product> findCommercialJavaComponents() {
        ArrayList<Product> components = new ArrayList<Product>();
        for (File f : this.getJarFiles()) {
            try {
                JarFile jarFile = new JarFile(f);
                Throwable throwable = null;
                try {
                    String cvdlName;
                    Attributes attributes;
                    Manifest manifest = jarFile.getManifest();
                    if (manifest == null || (attributes = manifest.getMainAttributes()) == null || (cvdlName = attributes.getValue("CvdlName")) == null) continue;
                    String version = attributes.getValue("Bundle-Version");
                    Product p = new Product(cvdlName, version);
                    components.add(p);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jarFile == null) continue;
                    if (throwable != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jarFile.close();
                }
            }
            catch (IOException e) {
                BuildFrontendMojo.getLogger().debug("Error reading manifest for jar " + f, (Throwable)e);
            }
        }
        return components;
    }

    private Set<File> getJarFiles() {
        return this.project.getArtifacts().stream().filter(artifact -> "jar".equals(artifact.getType())).map(Artifact::getFile).collect(Collectors.toSet());
    }

    private FrontendTools getFrontendTools() throws MojoExecutionException {
        URI nodeDownloadRootURI;
        try {
            nodeDownloadRootURI = new URI(this.nodeDownloadRoot);
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException("Failed to parse " + this.nodeDownloadRoot, (Exception)e);
        }
        return new FrontendTools(this.npmFolder.getAbsolutePath(), () -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath(), this.nodeVersion, nodeDownloadRootURI, this.requireHomeNodeExec);
    }

    private void readDetailsAndThrowException(Process webpackLaunch) {
        String stderr = this.readFullyAndClose("Failed to read webpack process stderr", webpackLaunch.getErrorStream());
        throw new IllegalStateException(String.format("Webpack process exited with non-zero exit code.%nStderr: '%s'", stderr));
    }

    private String readFullyAndClose(String readErrorMessage, InputStream inputStreamSupplier) {
        try {
            return IOUtils.toString((InputStream)inputStreamSupplier, (Charset)StandardCharsets.UTF_8).replaceAll("\\R", System.lineSeparator());
        }
        catch (IOException e) {
            throw new UncheckedIOException(readErrorMessage, e);
        }
    }

    private void updateBuildFile() {
        File tokenFile = this.getTokenFile();
        if (!tokenFile.exists()) {
            this.getLog().warn((CharSequence)"Couldn't update devMode token due to missing token file.");
            return;
        }
        try {
            String json = FileUtils.readFileToString((File)tokenFile, (String)StandardCharsets.UTF_8.name());
            JsonObject buildInfo = (JsonObject)JsonUtil.parse((String)json);
            buildInfo.remove("npmFolder");
            buildInfo.remove("generatedFolder");
            buildInfo.remove("frontendFolder");
            buildInfo.remove("node.version");
            buildInfo.remove("node.download.root");
            buildInfo.remove("pnpm.enable");
            buildInfo.remove("require.home.node");
            buildInfo.remove("ci.build");
            buildInfo.put("enableDevServer", false);
            FileUtils.write((File)tokenFile, (CharSequence)(JsonUtil.stringify((JsonValue)buildInfo, (int)2) + "\n"), (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Unable to read token file", (Throwable)e);
        }
    }

    @Override
    boolean isDefaultCompatibility() {
        File tokenFile = this.getTokenFile();
        if (!tokenFile.exists()) {
            this.getLog().warn((CharSequence)"'build-frontend' goal was called without previously calling 'prepare-frontend'");
            return true;
        }
        try {
            String json = FileUtils.readFileToString((File)tokenFile, (String)StandardCharsets.UTF_8.name());
            JsonObject buildInfo = (JsonObject)JsonUtil.parse((String)json);
            return buildInfo.hasKey("compatibilityMode") ? buildInfo.getBoolean("compatibilityMode") : true;
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Unable to read token file", (Throwable)e);
            return true;
        }
    }

    private File getTokenFile() {
        return new File(this.webpackOutputDirectory, "config/flow-build-info.json");
    }
}

