/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.maven;

import com.vaadin.flow.plugin.maven.FlowModeAbstractMojo;
import com.vaadin.flow.server.frontend.FrontendUtils;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="clean-frontend", defaultPhase=LifecyclePhase.CLEAN)
public class CleanFrontendMojo
extends FlowModeAbstractMojo {
    public static final String VAADIN = "vaadin";
    public static final String DEPENDENCIES = "dependencies";
    public static final String DEV_DEPENDENCIES = "devDependencies";
    public static final String OVERRIDES = "overrides";

    public void execute() throws MojoFailureException {
        this.removeNodeModules();
        File lockFile = new File(this.npmFolder(), "pnpm-lock.yaml");
        if (!lockFile.exists()) {
            lockFile = new File(this.npmFolder(), "package-lock.json");
        }
        if (lockFile.exists()) {
            lockFile.delete();
        }
        if (this.generatedTsFolder().exists()) {
            try {
                FileUtils.deleteDirectory((File)this.generatedTsFolder());
            }
            catch (IOException exception) {
                throw new MojoFailureException("Failed to remove folder'" + this.generatedTsFolder().getAbsolutePath() + "'", (Throwable)exception);
            }
        }
        try {
            File packageJsonFile = new File(this.npmFolder(), "package.json");
            if (packageJsonFile.exists()) {
                JsonObject packageJson = Json.parse((String)FileUtils.readFileToString((File)packageJsonFile, (String)StandardCharsets.UTF_8.name()));
                this.cleanupPackage(packageJson);
                FileUtils.write((File)packageJsonFile, (CharSequence)(JsonUtil.stringify((JsonValue)packageJson, (int)2) + "\n"), (String)StandardCharsets.UTF_8.name());
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to clean 'package.json' file", (Throwable)e);
        }
    }

    private void removeNodeModules() {
        File nodeModules = new File(this.npmFolder(), "node_modules");
        try {
            FrontendUtils.deleteNodeModules((File)nodeModules);
        }
        catch (IOException exception) {
            this.getLog().debug((CharSequence)"Exception removing node_modules", (Throwable)exception);
            this.getLog().error((CharSequence)("Failed to remove '" + nodeModules.getAbsolutePath() + "'. Please remove it manually."));
        }
    }

    private void cleanupPackage(JsonObject packageJson) {
        JsonObject dependencies = packageJson.getObject(DEPENDENCIES);
        JsonObject devDependencies = packageJson.getObject(DEV_DEPENDENCIES);
        JsonObject overridesSection = packageJson.getObject(OVERRIDES);
        if (packageJson.hasKey(VAADIN)) {
            JsonObject vaadin = packageJson.getObject(VAADIN);
            JsonObject vaadinDependencies = vaadin.getObject(DEPENDENCIES);
            JsonObject vaadinDevDependencies = vaadin.getObject(DEV_DEPENDENCIES);
            this.cleanObject(dependencies, vaadinDependencies);
            this.cleanObject(devDependencies, vaadinDevDependencies);
            this.cleanObject(overridesSection, vaadinDependencies, false);
            packageJson.remove(VAADIN);
        }
        this.cleanFrameworkBuildDependenices(dependencies);
        this.cleanFrameworkBuildDependenices(devDependencies);
        packageJson.remove("hash");
    }

    private void cleanObject(JsonObject target, JsonObject reference) {
        this.cleanObject(target, reference, true);
    }

    private void cleanObject(JsonObject target, JsonObject reference, boolean requireVersionsMatch) {
        if (target == null) {
            return;
        }
        HashSet<String> removeKeys = new HashSet<String>();
        for (String key : target.keys()) {
            if (!reference.hasKey(key) || requireVersionsMatch && !this.versionsMatch(target, reference, key)) continue;
            removeKeys.add(key);
        }
        for (String key : removeKeys) {
            target.remove(key);
        }
    }

    private boolean versionsMatch(JsonObject target, JsonObject reference, String key) {
        return target.getString(key).equals(reference.getString(key));
    }

    private void cleanFrameworkBuildDependenices(JsonObject dependencyObject) {
        if (dependencyObject == null) {
            return;
        }
        String buildTargetFolder = "./" + this.buildFolder();
        HashSet<String> removeKeys = new HashSet<String>();
        for (String key : dependencyObject.keys()) {
            if (!dependencyObject.getString(key).startsWith(buildTargetFolder)) continue;
            removeKeys.add(key);
        }
        for (String key : removeKeys) {
            dependencyObject.remove(key);
        }
    }
}

