/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.maven;

import com.vaadin.flow.plugin.base.BuildFrontendUtil;
import com.vaadin.flow.plugin.base.PluginAdapterBase;
import com.vaadin.flow.plugin.maven.FlowModeAbstractMojo;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.build.BuildContext;

@Mojo(name="prepare-frontend", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class PrepareFrontendMojo
extends FlowModeAbstractMojo {
    @Component
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.productionMode != null) {
            this.logWarn("The <productionMode>" + this.productionMode + "</productionMode> Maven parameter no longer has any effect and can be removed. Production mode is automatically enabled when you run the build-frontend target.");
        }
        try {
            FileUtils.deleteDirectory((File)this.generatedTsFolder());
            this.logDebug("Cleaned the generated folder '" + this.generatedTsFolder().getPath() + "'");
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to clean generated folder " + this.generatedTsFolder().getPath(), (Throwable)e);
        }
        File tokenFile = BuildFrontendUtil.propagateBuildInfo((PluginAdapterBase)this);
        if (this.buildContext != null) {
            this.buildContext.refresh(tokenFile.getParentFile());
        }
        try {
            BuildFrontendUtil.prepareFrontend((PluginAdapterBase)this);
        }
        catch (Exception exception) {
            throw new MojoFailureException("Could not execute prepare-frontend goal.", (Throwable)exception);
        }
    }
}

