/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.migration;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCopyResourcesStep {
    protected static final String BOWER_COMPONENTS = "bower_components";
    private final File target;
    private final List<File> resources;
    private final FileTreeHandler handler;

    public AbstractCopyResourcesStep(File target, File[] sourceFolders, FileTreeHandler handler) {
        this.target = target;
        this.resources = Arrays.asList(sourceFolders);
        this.handler = handler;
    }

    public Map<String, List<String>> copyResources() throws IOException {
        if (this.target.exists() && !this.target.isDirectory()) {
            throw new IOException("Target path " + this.target.getPath() + " exists and is not a directory");
        }
        if (!this.target.exists()) {
            FileUtils.forceMkdir((File)this.target);
        }
        AbstractCopyResourcesStep.getLogger().debug("Use {} as source folders to copy", this.resources);
        HashMap<String, List<String>> allResources = new HashMap<String, List<String>>();
        for (File resourceFolder : this.resources) {
            AbstractCopyResourcesStep.getLogger().debug("Copy resources from {} to {}", (Object)resourceFolder, (Object)this.target.getPath());
            allResources.put(resourceFolder.getPath(), this.doCopyResources(resourceFolder));
        }
        return allResources;
    }

    private List<String> doCopyResources(File source) throws IOException {
        CopyFileVisitor visitor = new CopyFileVisitor(source.toPath(), this.target.toPath(), this.handler);
        Files.walkFileTree(source.toPath(), visitor);
        return visitor.getVisitedPaths();
    }

    protected static String getRelativePath(Path source, Path against) {
        Path relativize = against.relativize(source);
        return StreamSupport.stream(relativize.spliterator(), false).map(Path::toString).collect(Collectors.joining("/"));
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(AbstractCopyResourcesStep.class);
    }

    private static class CopyFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path sourceRoot;
        private final Path targetRoot;
        private final FileTreeHandler writer;
        private List<String> paths = new ArrayList<String>();

        private CopyFileVisitor(Path sourceRoot, Path targetRoot, FileTreeHandler fileProducer) {
            this.sourceRoot = sourceRoot;
            this.targetRoot = targetRoot;
            this.writer = fileProducer;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path target = this.getTarget(file);
            AbstractCopyResourcesStep.getLogger().debug("Writing content to '{}'", (Object)target.toString());
            if (this.writer.handle(file, target)) {
                this.paths.add(AbstractCopyResourcesStep.getRelativePath(target, this.targetRoot));
            }
            return super.visitFile(file, attrs);
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path target = this.getTarget(dir);
            if (!this.writer.handle(dir, target)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            if (!target.toFile().exists()) {
                AbstractCopyResourcesStep.getLogger().debug("Creating a new {} directory", (Object)target.toString());
                Files.createDirectory(this.getTarget(dir), new FileAttribute[0]);
            } else {
                AbstractCopyResourcesStep.getLogger().debug("Directory/file {} already exists, skipping its creation", (Object)target.toString());
            }
            return super.preVisitDirectory(dir, attrs);
        }

        List<String> getVisitedPaths() {
            return this.paths;
        }

        private Path getTarget(Path source) {
            Path relativePath = this.sourceRoot.relativize(source);
            String topLevel = relativePath.getName(0).toString();
            if ("frontend".equals(topLevel)) {
                if (relativePath.getNameCount() == 1) {
                    return this.targetRoot;
                }
                relativePath = relativePath.subpath(1, relativePath.getNameCount());
            }
            return this.targetRoot.resolve(relativePath);
        }
    }

    protected static interface FileTreeHandler {
        public boolean handle(Path var1, Path var2) throws IOException;
    }
}

