/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.osgi.support;

import com.vaadin.flow.di.ResourceProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ServiceScope;

@Component(scope=ServiceScope.BUNDLE, service={ResourceProvider.class})
public class OSGiResourceProvider
implements ResourceProvider {
    private Bundle bundle;

    @Activate
    void activate(ComponentContext ctx) {
        this.bundle = ctx.getUsingBundle();
    }

    public URL getApplicationResource(String path) {
        return this.bundle.getResource(path);
    }

    public List<URL> getApplicationResources(String path) throws IOException {
        Enumeration resources = this.bundle.getResources(path);
        if (resources == null) {
            return Collections.emptyList();
        }
        return Collections.list(resources);
    }

    public URL getClientResource(String path) {
        Bundle[] bundles;
        for (Bundle bundle : bundles = FrameworkUtil.getBundle(OSGiResourceProvider.class).getBundleContext().getBundles()) {
            if (!"com.vaadin.flow.client".equals(bundle.getSymbolicName())) continue;
            return bundle.getResource(path);
        }
        return null;
    }

    public InputStream getClientResourceAsStream(String path) throws IOException {
        return this.getClientResource(path).openStream();
    }
}

